/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AttributeType {
    CommonName("2.5.4.3", "CN"),
    CountryName("2.5.4.6", "C"),
    DnQualifier("2.5.4.46", "DNQUALIFIER"),
    DomainComponent("0.9.2342.19200300.100.1.25", "DC"),
    EmailAddress("1.2.840.113549.1.9.1", "EMAILADDRESS"),
    GenerationQualifier("2.5.4.44", "GENERATIONQUALIFIER"),
    GivenName("2.5.4.42", "GIVENNAME"),
    Initials("2.5.4.43", "INITIALS"),
    LocalityName("2.5.4.7", "L"),
    Mail("0.9.2342.19200300.100.1.3", "MAIL"),
    Name("2.5.4.41", "NAME"),
    OrganizationName("2.5.4.10", "O"),
    OrganizationalUnitName("2.5.4.11", "OU"),
    PostalAddress("2.5.4.16", "POSTALADDRESS"),
    PostalCode("2.5.4.17", "POSTALCODE"),
    PostOfficeBox("2.5.4.18", "POSTOFFICEBOX"),
    SerialNumber("2.5.4.5", "SERIALNUMBER"),
    StateOrProvinceName("2.5.4.8", "ST"),
    StreetAddress("2.5.4.9", "STREET"),
    Surname("2.5.4.4", "STREET"),
    Title("2.5.4.12", "TITLE"),
    UniqueIdentifier("0.9.2342.19200300.100.1.44", "UNIQUEIDENTIFIER"),
    UserId("0.9.2342.19200300.100.1.1", "UID");

    private String oid;
    private String name;

    private AttributeType(String attributeTypeOid, String shortName) {
        this.oid = attributeTypeOid;
        this.name = shortName;
    }

    public String getOid() {
        return this.oid;
    }

    public String getName() {
        return this.name;
    }

    public static AttributeType fromOid(String oid) {
        for (AttributeType t : AttributeType.values()) {
            if (!t.getOid().equals(oid)) continue;
            return t;
        }
        throw new IllegalArgumentException("Unknown AttributeType for OID " + oid);
    }

    public static AttributeType fromName(String name) {
        for (AttributeType t : AttributeType.values()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        throw new IllegalArgumentException("Unknown AttributeType for name " + name);
    }
}

