/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

public final class DERHelper {
    private DERHelper() {
    }

    public static int asInt(DEREncodable e) {
        if (!(e instanceof DERInteger)) {
            throw new IllegalArgumentException("Argument must be DERInteger.");
        }
        return ((DERInteger)e).getValue().intValue();
    }

    public static byte[] asOctets(DEREncodable e) {
        if (!(e instanceof DEROctetString)) {
            throw new IllegalArgumentException("Argument must be DEROctetString.");
        }
        return ((DEROctetString)e).getOctets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DERObject toDERObject(byte[] data, boolean discardWrapper) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            DERObject o = new ASN1InputStream((InputStream)in).readObject();
            if (discardWrapper && o instanceof ASN1OctetString) {
                o = new ASN1InputStream(((ASN1OctetString)o).getOctets()).readObject();
            }
            DERObject dERObject = o;
            return dERObject;
        }
        finally {
            in.close();
        }
    }
}

