/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.provider;

import java.util.Collection;
import java.util.Iterator;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.provider.FilterException;
import org.opensaml.saml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml.security.SAMLSignatureProfileValidator;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidationFilter
implements MetadataFilter {
    private final Logger log = LoggerFactory.getLogger(SignatureValidationFilter.class);
    private SignatureTrustEngine signatureTrustEngine;
    private boolean requireSignature;
    private CriteriaSet defaultCriteria;
    private SAMLSignatureProfileValidator sigValidator;

    public SignatureValidationFilter(SignatureTrustEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Signature trust engine may not be null");
        }
        this.signatureTrustEngine = engine;
        this.sigValidator = new SAMLSignatureProfileValidator();
    }

    public SignatureTrustEngine getSignatureTrustEngine() {
        return this.signatureTrustEngine;
    }

    public SAMLSignatureProfileValidator getSignaturePrevalidator() {
        return this.sigValidator;
    }

    public boolean getRequireSignature() {
        return this.requireSignature;
    }

    public void setRequireSignature(boolean require) {
        this.requireSignature = require;
    }

    public CriteriaSet getDefaultCriteria() {
        return this.defaultCriteria;
    }

    public void setDefaultCriteria(CriteriaSet newCriteria) {
        this.defaultCriteria = newCriteria;
    }

    public void doFilter(XMLObject metadata) throws FilterException {
        SignableXMLObject signableMetadata = (SignableXMLObject)metadata;
        if (!signableMetadata.isSigned() && this.getRequireSignature()) {
            throw new FilterException("Metadata root element was unsigned and signatures are required.");
        }
        if (signableMetadata instanceof EntityDescriptor) {
            this.processEntityDescriptor((EntityDescriptor)signableMetadata);
        } else if (signableMetadata instanceof EntitiesDescriptor) {
            this.processEntityGroup((EntitiesDescriptor)signableMetadata);
        } else {
            this.log.error("Internal error, metadata object was of an unsupported type: {}", (Object)metadata.getClass().getName());
        }
    }

    protected void processEntityDescriptor(EntityDescriptor entityDescriptor) throws FilterException {
        String entityID = entityDescriptor.getEntityID();
        this.log.trace("Processing EntityDescriptor: {}", (Object)entityID);
        if (entityDescriptor.isSigned()) {
            this.verifySignature((SignableXMLObject)entityDescriptor, entityID, false);
        }
        Iterator roleIter = entityDescriptor.getRoleDescriptors().iterator();
        while (roleIter.hasNext()) {
            RoleDescriptor roleChild = (RoleDescriptor)roleIter.next();
            if (!roleChild.isSigned()) {
                this.log.trace("RoleDescriptor member '{}' was not signed, skipping signature processing...", (Object)roleChild.getElementQName());
                continue;
            }
            this.log.trace("Processing signed RoleDescriptor member: {}", (Object)roleChild.getElementQName());
            try {
                String roleID = this.getRoleIDToken(entityID, roleChild);
                this.verifySignature((SignableXMLObject)roleChild, roleID, false);
            }
            catch (FilterException e) {
                this.log.error("RoleDescriptor '{}' subordinate to entity '{}' failed signature verification, removing from metadata provider", (Object)roleChild.getElementQName(), (Object)entityID);
                roleIter.remove();
            }
        }
        if (entityDescriptor.getAffiliationDescriptor() != null) {
            AffiliationDescriptor affiliationDescriptor = entityDescriptor.getAffiliationDescriptor();
            if (!affiliationDescriptor.isSigned()) {
                this.log.trace("AffiliationDescriptor member was not signed, skipping signature processing...");
            } else {
                this.log.trace("Processing signed AffiliationDescriptor member with owner ID: {}", (Object)affiliationDescriptor.getOwnerID());
                try {
                    this.verifySignature((SignableXMLObject)affiliationDescriptor, affiliationDescriptor.getOwnerID(), false);
                }
                catch (FilterException e) {
                    this.log.error("AffiliationDescriptor with owner ID '{}' subordinate to entity '{}' failed signature verification, removing from metadata provider", (Object)affiliationDescriptor.getOwnerID(), (Object)entityID);
                    entityDescriptor.setAffiliationDescriptor(null);
                }
            }
        }
    }

    protected void processEntityGroup(EntitiesDescriptor entitiesDescriptor) throws FilterException {
        this.log.trace("Processing EntitiesDescriptor group: {}", (Object)entitiesDescriptor.getName());
        if (entitiesDescriptor.isSigned()) {
            this.verifySignature((SignableXMLObject)entitiesDescriptor, entitiesDescriptor.getName(), true);
        }
        Iterator entityIter = entitiesDescriptor.getEntityDescriptors().iterator();
        while (entityIter.hasNext()) {
            EntityDescriptor entityChild = (EntityDescriptor)entityIter.next();
            if (!entityChild.isSigned()) {
                this.log.trace("EntityDescriptor member '{}' was not signed, skipping signature processing...", (Object)entityChild.getEntityID());
                continue;
            }
            this.log.trace("Processing signed EntityDescriptor member: {}", (Object)entityChild.getEntityID());
            try {
                this.processEntityDescriptor(entityChild);
            }
            catch (FilterException e) {
                this.log.error("EntityDescriptor '{}' failed signature verification, removing from metadata provider", (Object)entityChild.getEntityID());
                entityIter.remove();
            }
        }
        Iterator entitiesIter = entitiesDescriptor.getEntitiesDescriptors().iterator();
        while (entitiesIter.hasNext()) {
            EntitiesDescriptor entitiesChild = (EntitiesDescriptor)entitiesIter.next();
            this.log.trace("Processing EntitiesDescriptor member: {}", (Object)entitiesChild.getName());
            try {
                this.processEntityGroup(entitiesChild);
            }
            catch (FilterException e) {
                this.log.error("EntitiesDescriptor '{}' failed signature verification, removing from metadata provider", (Object)entitiesChild.getName());
                entitiesIter.remove();
            }
        }
    }

    protected void verifySignature(SignableXMLObject signedMetadata, String metadataEntryName, boolean isEntityGroup) throws FilterException {
        this.log.debug("Verifying signature on metadata entry: {}", (Object)metadataEntryName);
        Signature signature = signedMetadata.getSignature();
        if (signature == null) {
            this.log.warn("Signature was null, skipping processing on metadata entry: {}", (Object)metadataEntryName);
            return;
        }
        this.performPreValidation(signature, metadataEntryName);
        CriteriaSet criteriaSet = this.buildCriteriaSet(signedMetadata, metadataEntryName, isEntityGroup);
        try {
            if (this.getSignatureTrustEngine().validate((Object)signature, criteriaSet)) {
                this.log.trace("Signature trust establishment succeeded for metadata entry {}", (Object)metadataEntryName);
                return;
            }
            this.log.error("Signature trust establishment failed for metadata entry {}", (Object)metadataEntryName);
            throw new FilterException("Signature trust establishment failed for metadata entry");
        }
        catch (SecurityException e) {
            this.log.error("Error processing signature verification for metadata entry '{}': {} ", (Object)metadataEntryName, (Object)e.getMessage());
            throw new FilterException("Error processing signature verification for metadata entry", (Exception)((Object)e));
        }
    }

    protected void performPreValidation(Signature signature, String metadataEntryName) throws FilterException {
        if (this.getSignaturePrevalidator() != null) {
            try {
                this.getSignaturePrevalidator().validate(signature);
            }
            catch (SignatureException e) {
                this.log.error("Signature on metadata entry '{}' failed signature pre-validation", (Object)metadataEntryName);
                throw new FilterException("Metadata instance signature failed signature pre-validation", (Exception)((Object)e));
            }
        }
    }

    protected CriteriaSet buildCriteriaSet(SignableXMLObject signedMetadata, String metadataEntryName, boolean isEntityGroup) {
        CriteriaSet newCriteriaSet = new CriteriaSet();
        if (this.getDefaultCriteria() != null) {
            newCriteriaSet.addAll((Collection)this.getDefaultCriteria());
        }
        if (!newCriteriaSet.contains(UsageCriterion.class)) {
            newCriteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        }
        return newCriteriaSet;
    }

    protected String getRoleIDToken(String entityID, RoleDescriptor role) {
        String roleName = role.getElementQName().getLocalPart();
        return "[Role: " + entityID + "::" + roleName + "]";
    }
}

