/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.metadata.provider.FilterException;
import org.opensaml.saml.saml2.metadata.provider.MetadataFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataFilterChain
implements MetadataFilter {
    private Logger log = LoggerFactory.getLogger(MetadataFilterChain.class);
    private List<MetadataFilter> filters = Collections.emptyList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(XMLObject xmlObject) throws FilterException {
        List<MetadataFilter> list = this.filters;
        synchronized (list) {
            if (this.filters == null || this.filters.isEmpty()) {
                this.log.debug("No filters configured, nothing to do");
            }
            for (MetadataFilter filter : this.filters) {
                this.log.debug("Applying filter {}", (Object)filter.getClass().getName());
                filter.doFilter(xmlObject);
            }
        }
    }

    public List<MetadataFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<MetadataFilter> newFilters) {
        if (newFilters == null || newFilters.isEmpty()) {
            this.filters.clear();
        }
        ArrayList<MetadataFilter> checkedFilters = new ArrayList<MetadataFilter>();
        for (MetadataFilter filter : newFilters) {
            if (filter == null) continue;
            checkedFilters.add(filter);
        }
        this.filters = checkedFilters;
    }
}

