/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.provider.FilterException;
import org.opensaml.saml.saml2.metadata.provider.MetadataFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRoleFilter
implements MetadataFilter {
    private final Logger log = LoggerFactory.getLogger(EntityRoleFilter.class);
    private List<QName> roleWhiteList;
    private boolean removeRolelessEntityDescriptors;
    private boolean removeEmptyEntitiesDescriptors;
    private final QName extRoleDescriptor = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "RoleDescriptor");

    public EntityRoleFilter(List<QName> keptRoles) {
        this.roleWhiteList = new ArrayList<QName>();
        if (keptRoles != null) {
            this.roleWhiteList.addAll(keptRoles);
        }
        this.roleWhiteList = Collections.unmodifiableList(this.roleWhiteList);
        this.removeRolelessEntityDescriptors = true;
        this.removeEmptyEntitiesDescriptors = true;
    }

    public List<QName> getRoleWhiteList() {
        return this.roleWhiteList;
    }

    public boolean getRemoveRolelessEntityDescriptors() {
        return this.removeRolelessEntityDescriptors;
    }

    public void setRemoveRolelessEntityDescriptors(boolean remove) {
        this.removeRolelessEntityDescriptors = remove;
    }

    public boolean getRemoveEmptyEntitiesDescriptors() {
        return this.removeEmptyEntitiesDescriptors;
    }

    public void setRemoveEmptyEntitiesDescriptors(boolean remove) {
        this.removeEmptyEntitiesDescriptors = remove;
    }

    public void doFilter(XMLObject metadata) throws FilterException {
        if (metadata == null) {
            return;
        }
        if (metadata instanceof EntitiesDescriptor) {
            this.filterEntitiesDescriptor((EntitiesDescriptor)metadata);
        } else {
            this.filterEntityDescriptor((EntityDescriptor)metadata);
        }
    }

    protected void filterEntitiesDescriptor(EntitiesDescriptor descriptor) throws FilterException {
        List entitiesDescriptors;
        List entityDescriptors = descriptor.getEntityDescriptors();
        if (entityDescriptors != null && !entityDescriptors.isEmpty()) {
            ArrayList<EntityDescriptor> emptyEntityDescriptors = new ArrayList<EntityDescriptor>();
            for (EntityDescriptor entityDescriptor : entityDescriptors) {
                List entityRoles;
                this.filterEntityDescriptor(entityDescriptor);
                if (!this.getRemoveRolelessEntityDescriptors() || (entityRoles = entityDescriptor.getRoleDescriptors()) != null && !entityRoles.isEmpty()) continue;
                this.log.trace("Filtering out entity descriptor {} from entity group {}", (Object)entityDescriptor.getEntityID(), (Object)descriptor.getName());
                emptyEntityDescriptors.add(entityDescriptor);
            }
            entityDescriptors.removeAll(emptyEntityDescriptors);
        }
        if ((entitiesDescriptors = descriptor.getEntitiesDescriptors()) != null && !entitiesDescriptors.isEmpty()) {
            ArrayList<EntitiesDescriptor> emptyEntitiesDescriptors = new ArrayList<EntitiesDescriptor>();
            for (EntitiesDescriptor entitiesDescriptor : entitiesDescriptors) {
                this.filterEntitiesDescriptor(entitiesDescriptor);
                if (!this.getRemoveEmptyEntitiesDescriptors() || entitiesDescriptor.getEntityDescriptors() != null && !entitiesDescriptor.getEntityDescriptors().isEmpty() || entitiesDescriptor.getEntitiesDescriptors() != null && !entitiesDescriptor.getEntitiesDescriptors().isEmpty()) continue;
                this.log.trace("Filtering out entity descriptor {} from entity group {}", (Object)entitiesDescriptor.getName(), (Object)descriptor.getName());
                emptyEntitiesDescriptors.add(entitiesDescriptor);
            }
            entitiesDescriptors.removeAll(emptyEntitiesDescriptors);
        }
    }

    protected void filterEntityDescriptor(EntityDescriptor descriptor) throws FilterException {
        List roles = descriptor.getRoleDescriptors();
        if (roles != null && !roles.isEmpty()) {
            Iterator rolesItr = roles.iterator();
            while (rolesItr.hasNext()) {
                QName roleName = this.getRoleName((RoleDescriptor)rolesItr.next());
                if (this.roleWhiteList.contains(roleName)) continue;
                this.log.trace("Filtering out role {} from entity {}", (Object)roleName, (Object)descriptor.getEntityID());
                rolesItr.remove();
            }
        }
    }

    protected QName getRoleName(RoleDescriptor role) throws FilterException {
        QName roleName = role.getElementQName();
        if (this.extRoleDescriptor.equals(roleName) && (roleName = role.getSchemaType()) == null) {
            throw new FilterException("Role descriptor element was " + this.extRoleDescriptor + " but did not contain a schema type.  This is illegal.");
        }
        return roleName;
    }
}

