/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.impl.SSODescriptorImpl;
import org.opensaml.saml.saml2.metadata.support.AttributeConsumingServiceSelector;
import org.opensaml.saml.saml2.metadata.support.SAML2MetadataHelper;

public class SPSSODescriptorImpl
extends SSODescriptorImpl
implements SPSSODescriptor {
    private XSBooleanValue authnRequestSigned;
    private XSBooleanValue assertionSigned;
    private final XMLObjectChildrenList<AssertionConsumerService> assertionConsumerServices = new XMLObjectChildrenList((XMLObject)this);
    private final XMLObjectChildrenList<AttributeConsumingService> attributeConsumingServices = new XMLObjectChildrenList((XMLObject)this);

    protected SPSSODescriptorImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public Boolean isAuthnRequestsSigned() {
        if (this.authnRequestSigned == null) {
            return Boolean.FALSE;
        }
        return this.authnRequestSigned.getValue();
    }

    public XSBooleanValue isAuthnRequestsSignedXSBoolean() {
        return this.authnRequestSigned;
    }

    public void setAuthnRequestsSigned(Boolean newIsSigned) {
        this.authnRequestSigned = newIsSigned != null ? (XSBooleanValue)this.prepareForAssignment(this.authnRequestSigned, new XSBooleanValue(newIsSigned, false)) : (XSBooleanValue)this.prepareForAssignment(this.authnRequestSigned, null);
    }

    public void setAuthnRequestsSigned(XSBooleanValue isSigned) {
        this.authnRequestSigned = (XSBooleanValue)this.prepareForAssignment(this.authnRequestSigned, isSigned);
    }

    public Boolean getWantAssertionsSigned() {
        if (this.assertionSigned == null) {
            return Boolean.FALSE;
        }
        return this.assertionSigned.getValue();
    }

    public XSBooleanValue getWantAssertionsSignedXSBoolean() {
        return this.assertionSigned;
    }

    public void setWantAssertionsSigned(Boolean wantAssestionSigned) {
        this.assertionSigned = wantAssestionSigned != null ? (XSBooleanValue)this.prepareForAssignment(this.assertionSigned, new XSBooleanValue(wantAssestionSigned, false)) : (XSBooleanValue)this.prepareForAssignment(this.assertionSigned, null);
    }

    public void setWantAssertionsSigned(XSBooleanValue wantAssestionSigned) {
        this.assertionSigned = (XSBooleanValue)this.prepareForAssignment(this.assertionSigned, wantAssestionSigned);
    }

    public List<AssertionConsumerService> getAssertionConsumerServices() {
        return this.assertionConsumerServices;
    }

    public AssertionConsumerService getDefaultAssertionConsumerService() {
        return (AssertionConsumerService)SAML2MetadataHelper.getDefaultIndexedEndpoint(this.assertionConsumerServices);
    }

    public List<AttributeConsumingService> getAttributeConsumingServices() {
        return this.attributeConsumingServices;
    }

    public AttributeConsumingService getDefaultAttributeConsumingService() {
        AttributeConsumingServiceSelector selector = new AttributeConsumingServiceSelector();
        selector.setRoleDescriptor((RoleDescriptor)this);
        return selector.selectService();
    }

    @Override
    public List<Endpoint> getEndpoints() {
        ArrayList<Object> endpoints = new ArrayList<Object>();
        endpoints.addAll(super.getEndpoints());
        endpoints.addAll((Collection<Object>)this.assertionConsumerServices);
        return Collections.unmodifiableList(endpoints);
    }

    @Override
    public List<Endpoint> getEndpoints(QName type) {
        if (type.equals(AssertionConsumerService.DEFAULT_ELEMENT_NAME)) {
            return Collections.unmodifiableList(new ArrayList<AssertionConsumerService>((Collection<AssertionConsumerService>)this.assertionConsumerServices));
        }
        return super.getEndpoints(type);
    }

    @Override
    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        children.addAll(super.getOrderedChildren());
        children.addAll((Collection<Object>)this.assertionConsumerServices);
        children.addAll((Collection<Object>)this.attributeConsumingServices);
        return Collections.unmodifiableList(children);
    }
}

