/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.security;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.opensaml.saml.common.binding.SAMLMessageContext;
import org.opensaml.saml.common.binding.security.BaseSAMLSimpleSignatureSecurityPolicyRule;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2HTTPRedirectDeflateSignatureRule
extends BaseSAMLSimpleSignatureSecurityPolicyRule {
    private final Logger log = LoggerFactory.getLogger(SAML2HTTPRedirectDeflateSignatureRule.class);

    public SAML2HTTPRedirectDeflateSignatureRule(SignatureTrustEngine engine) {
        super(engine);
    }

    @Override
    protected boolean ruleHandles(HttpServletRequest request, SAMLMessageContext samlMsgCtx) throws SecurityPolicyException {
        return "GET".equals(request.getMethod());
    }

    @Override
    protected byte[] getSignedContent(HttpServletRequest request) throws SecurityPolicyException {
        String queryString = request.getQueryString();
        this.log.debug("Constructing signed content string from URL query string {}", (Object)queryString);
        String constructed = this.buildSignedContentString(queryString);
        if (Strings.isNullOrEmpty((String)constructed)) {
            this.log.warn("Could not extract signed content string from query string");
            return null;
        }
        this.log.debug("Constructed signed content string for HTTP-Redirect DEFLATE {}", (Object)constructed);
        try {
            return constructed.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private String buildSignedContentString(String queryString) throws SecurityPolicyException {
        StringBuilder builder = new StringBuilder();
        if (!this.appendParameter(builder, queryString, "SAMLRequest") && !this.appendParameter(builder, queryString, "SAMLResponse")) {
            this.log.warn("Could not extract either a SAMLRequest or a SAMLResponse from the query string");
            throw new SecurityPolicyException("Extract of SAMLRequest or SAMLResponse from query string failed");
        }
        this.appendParameter(builder, queryString, "RelayState");
        this.appendParameter(builder, queryString, "SigAlg");
        return builder.toString();
    }

    private boolean appendParameter(StringBuilder builder, String queryString, String paramName) {
        String rawParam = HTTPTransportUtils.getRawQueryStringParameter((String)queryString, (String)paramName);
        if (rawParam == null) {
            return false;
        }
        if (builder.length() > 0) {
            builder.append('&');
        }
        builder.append(rawParam);
        return true;
    }
}

