/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.binding.encoding.BaseSAML2MessageEncoder;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.opensaml.soap.messaging.context.Soap11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTTPSOAP11Encoder
extends BaseSAML2MessageEncoder {
    private final Logger log = LoggerFactory.getLogger(HTTPSOAP11Encoder.class);

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:SOAP";
    }

    public boolean providesMessageConfidentiality(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    public boolean providesMessageIntegrity(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    public void prepareContext() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        SAMLObject samlMessage = (SAMLObject)messageContext.getMessage();
        if (samlMessage == null) {
            throw new MessageEncodingException("No outbound SAML message contained in message context");
        }
        this.signMessage((MessageContext<SAMLObject>)messageContext);
        Envelope envelope = this.buildSOAPMessage(samlMessage);
        this.storeSOAPEnvelope(envelope);
    }

    protected void doEncode() throws MessageEncodingException {
        Envelope envelope = this.getSOAPEnvelope();
        Element envelopeElem = this.marshallMessage((XMLObject)envelope);
        HttpServletResponse response = this.getHttpServletResponse();
        HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
        HttpServletSupport.setUTF8Encoding((HttpServletResponse)response);
        HttpServletSupport.setContentType((HttpServletResponse)response, (String)"text/xml");
        response.setHeader("SOAPAction", "http://www.oasis-open.org/committees/security");
        try {
            SerializeSupport.writeNode((Node)envelopeElem, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem writing SOAP envelope to servlet output stream", (Exception)e);
        }
    }

    protected void storeSOAPEnvelope(Envelope envelope) {
        ((Soap11Context)this.getMessageContext().getSubcontext(Soap11Context.class, true)).setEnvelope(envelope);
    }

    protected Envelope getSOAPEnvelope() {
        return ((Soap11Context)this.getMessageContext().getSubcontext(Soap11Context.class, true)).getEnvelope();
    }

    protected Envelope buildSOAPMessage(SAMLObject samlMessage) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Building SOAP message");
        }
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SOAPObjectBuilder envBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        Envelope envelope = (Envelope)envBuilder.buildObject();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adding SAML message to the SOAP message's body");
        }
        SOAPObjectBuilder bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
        Body body = (Body)bodyBuilder.buildObject();
        body.getUnknownXMLObjects().add(samlMessage);
        envelope.setBody(body);
        return envelope;
    }
}

