/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.velocity.VelocityContext;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.binding.encoding.HTTPPostEncoder;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.SecurityConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class HTTPPostSimpleSignEncoder
extends HTTPPostEncoder {
    private final Logger log = LoggerFactory.getLogger(HTTPPostSimpleSignEncoder.class);
    private boolean signWithXmlSignature;

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign";
    }

    public boolean isSignWithXmlSignature() {
        return this.signWithXmlSignature;
    }

    public void setSignWithXmlSignature(boolean newSignWithXmlSignature) {
        this.signWithXmlSignature = newSignWithXmlSignature;
    }

    @Override
    protected void signMessage(MessageContext<SAMLObject> messageContext) throws MessageEncodingException {
        if (this.signWithXmlSignature) {
            super.signMessage(messageContext);
        }
    }

    @Override
    protected void populateVelocityContext(VelocityContext velocityContext, MessageContext<SAMLObject> messageContext, String endpointURL) throws MessageEncodingException {
        String kiBase64;
        super.populateVelocityContext(velocityContext, messageContext, endpointURL);
        Credential signingCredential = this.getContextSigningCredential(messageContext);
        if (signingCredential == null) {
            this.log.debug("No signing credential was supplied, skipping HTTP-Post simple signing");
            return;
        }
        String sigAlgURI = this.getSignatureAlgorithmURI(signingCredential, null);
        velocityContext.put("SigAlg", (Object)sigAlgURI);
        String formControlData = this.buildFormDataToSign(velocityContext, messageContext, sigAlgURI);
        velocityContext.put("Signature", (Object)this.generateSignature(signingCredential, sigAlgURI, formControlData));
        KeyInfoGenerator kiGenerator = KeyInfoSupport.getKeyInfoGenerator((Credential)signingCredential, null, null);
        if (kiGenerator != null && !Strings.isNullOrEmpty((String)(kiBase64 = this.buildKeyInfo(signingCredential, kiGenerator)))) {
            velocityContext.put("KeyInfo", (Object)kiBase64);
        }
    }

    protected String buildKeyInfo(Credential signingCredential, KeyInfoGenerator kiGenerator) throws MessageEncodingException {
        try {
            KeyInfo keyInfo = kiGenerator.generate(signingCredential);
            if (keyInfo != null) {
                Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)keyInfo);
                if (marshaller == null) {
                    this.log.error("No KeyInfo marshaller available from configuration");
                    throw new MessageEncodingException("No KeyInfo marshaller was configured");
                }
                String kiXML = SerializeSupport.nodeToString((Node)marshaller.marshall((XMLObject)keyInfo));
                String kiBase64 = Base64Support.encode((byte[])kiXML.getBytes(), (boolean)false);
                return kiBase64;
            }
            return null;
        }
        catch (SecurityException e) {
            this.log.error("Error generating KeyInfo from signing credential", (Throwable)e);
            throw new MessageEncodingException("Error generating KeyInfo from signing credential", (Exception)((Object)e));
        }
        catch (MarshallingException e) {
            this.log.error("Error marshalling KeyInfo based on signing credential", (Throwable)e);
            throw new MessageEncodingException("Error marshalling KeyInfo based on signing credential", (Exception)((Object)e));
        }
    }

    protected String buildFormDataToSign(VelocityContext velocityContext, MessageContext<SAMLObject> messageContext, String sigAlgURI) {
        StringBuilder builder = new StringBuilder();
        boolean isRequest = false;
        if (velocityContext.get("SAMLRequest") != null) {
            isRequest = true;
        }
        String msgB64 = isRequest ? (String)velocityContext.get("SAMLRequest") : (String)velocityContext.get("SAMLResponse");
        String msg = null;
        try {
            msg = new String(Base64Support.decode((String)msgB64), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (isRequest) {
            builder.append("SAMLRequest=" + msg);
        } else {
            builder.append("SAMLResponse=" + msg);
        }
        String relayState = SAMLBindingSupport.getRelayState(messageContext);
        if (relayState != null) {
            builder.append("&RelayState=" + relayState);
        }
        builder.append("&SigAlg=" + sigAlgURI);
        return builder.toString();
    }

    protected String getSignatureAlgorithmURI(Credential credential, SecurityConfiguration config) throws MessageEncodingException {
        SecurityConfiguration secConfig = config != null ? config : SecurityConfigurationSupport.getGlobalXMLSecurityConfiguration();
        String signAlgo = secConfig.getSignatureAlgorithmURI(credential);
        if (signAlgo == null) {
            throw new MessageEncodingException("The signing credential's algorithm URI could not be derived");
        }
        return signAlgo;
    }

    protected String generateSignature(Credential signingCredential, String algorithmURI, String formData) throws MessageEncodingException {
        this.log.debug(String.format("Generating signature with key type '%s', algorithm URI '%s' over form control string '%s'", CredentialSupport.extractSigningKey((Credential)signingCredential).getAlgorithm(), algorithmURI, formData));
        String b64Signature = null;
        try {
            byte[] rawSignature = XMLSigningUtil.signWithURI((Credential)signingCredential, (String)algorithmURI, (byte[])formData.getBytes("UTF-8"));
            b64Signature = Base64Support.encode((byte[])rawSignature, (boolean)false);
            this.log.debug("Generated digital signature value (base64-encoded) {}", (Object)b64Signature);
        }
        catch (SecurityException e) {
            this.log.error("Error during URL signing process", (Throwable)e);
            throw new MessageEncodingException("Unable to sign form control string", (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return b64Signature;
    }
}

