/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.encoding;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.UriSupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.messaging.context.BasicMessageMetadataContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.context.SamlArtifactContext;
import org.opensaml.saml.config.SAMLConfigurationSupport;
import org.opensaml.saml.saml1.binding.artifact.AbstractSAML1Artifact;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactBuilder;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0001;
import org.opensaml.saml.saml1.binding.encoding.BaseSAML1MessageEncoder;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPArtifactEncoder
extends BaseSAML1MessageEncoder {
    private final Logger log = LoggerFactory.getLogger(HTTPArtifactEncoder.class);
    private SAMLArtifactMap artifactMap;
    private byte[] defaultArtifactType = SAML1ArtifactType0001.TYPE_CODE;

    public HTTPArtifactEncoder(SAMLArtifactMap map) {
    }

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01";
    }

    public SAMLArtifactMap getArtifactMap() {
        return this.artifactMap;
    }

    public void setArtifactMap(SAMLArtifactMap newArtifactMap) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.artifactMap = newArtifactMap;
    }

    public boolean providesMessageConfidentiality(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    public boolean providesMessageIntegrity(MessageContext messageContext) throws MessageEncodingException {
        return false;
    }

    protected void doDestroy() {
        this.artifactMap = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.artifactMap == null) {
            throw new ComponentInitializationException("SAML artifact map must be supplied");
        }
    }

    protected void doEncode() throws MessageEncodingException {
        SAML1ArtifactBuilder artifactBuilder;
        byte[] artifactType;
        MessageContext messageContext = this.getMessageContext();
        URI endpointUrl = this.getEndpointURL((MessageContext<SAMLObject>)messageContext);
        List params = UriSupport.parseQueryString((String)endpointUrl.getQuery());
        String relayState = SAMLBindingSupport.getRelayState((MessageContext)messageContext);
        if (SAMLBindingSupport.checkRelayState((String)relayState)) {
            params.add(new Pair((Object)"TARGET", (Object)relayState));
        }
        if ((artifactType = this.getSamlArtifactType((MessageContext<SAMLObject>)messageContext)) != null) {
            artifactBuilder = SAMLConfigurationSupport.getSAML1ArtifactBuilderFactory().getArtifactBuilder(artifactType);
        } else {
            artifactBuilder = SAMLConfigurationSupport.getSAML1ArtifactBuilderFactory().getArtifactBuilder(this.defaultArtifactType);
            this.storeSamlArtifactType((MessageContext<SAMLObject>)messageContext, this.defaultArtifactType);
        }
        SAMLObject outboundMessage = (SAMLObject)messageContext.getMessage();
        if (!(outboundMessage instanceof Response)) {
            throw new MessageEncodingException("Outbound message was not a SAML 1 Response");
        }
        Response samlResponse = (Response)outboundMessage;
        for (Assertion assertion : samlResponse.getAssertions()) {
            AbstractSAML1Artifact artifact = artifactBuilder.buildArtifact(messageContext, assertion);
            if (artifact == null) {
                this.log.error("Unable to build artifact for message to relying party");
                throw new MessageEncodingException("Unable to builder artifact for message to relying party");
            }
            try {
                this.artifactMap.put(artifact.base64Encode(), this.getInboundMessageIssuer((MessageContext<SAMLObject>)messageContext), this.getOutboundMessageIssuer((MessageContext<SAMLObject>)messageContext), (SAMLObject)assertion);
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall assertion to be represented as an artifact", (Throwable)e);
                throw new MessageEncodingException("Unable to marshall assertion to be represented as an artifact", (Exception)((Object)e));
            }
            String artifactString = artifact.base64Encode();
            params.add(new Pair((Object)"SAMLart", (Object)artifactString));
        }
        endpointUrl = UriSupport.setQuery((URI)endpointUrl, (List)params);
        String encodedEndpoint = endpointUrl.toASCIIString();
        this.log.debug("Sending redirect to URL {} to relying party {}", (Object)encodedEndpoint, (Object)this.getInboundMessageIssuer((MessageContext<SAMLObject>)messageContext));
        HttpServletResponse response = this.getHttpServletResponse();
        try {
            response.sendRedirect(encodedEndpoint);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem sending HTTP redirect", (Exception)e);
        }
    }

    private String getOutboundMessageIssuer(MessageContext<SAMLObject> messageContext) {
        BasicMessageMetadataContext basicContext = (BasicMessageMetadataContext)messageContext.getSubcontext(BasicMessageMetadataContext.class, false);
        Constraint.isNotNull((Object)basicContext, (String)"Message context did not contain a BasicMessageMetadataContext");
        return basicContext.getMessageIssuer();
    }

    private String getInboundMessageIssuer(MessageContext<SAMLObject> messageContext) {
        return null;
    }

    private void storeSamlArtifactType(MessageContext<SAMLObject> messageContext, byte[] artifactType) {
        ((SamlArtifactContext)messageContext.getSubcontext(SamlArtifactContext.class, true)).setArtifactType(artifactType);
    }

    private byte[] getSamlArtifactType(MessageContext<SAMLObject> messageContext) {
        return ((SamlArtifactContext)messageContext.getSubcontext(SamlArtifactContext.class, true)).getArtifactType();
    }
}

