/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.decoding;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXmlMessageDecoder;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.soap.messaging.context.Soap11Context;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPSOAP11Decoder
extends BaseHttpServletRequestXmlMessageDecoder<SAMLObject>
implements SAMLMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(HTTPSOAP11Decoder.class);

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding";
    }

    protected void doDecode() throws MessageDecodingException {
        Envelope soapMessage;
        MessageContext messageContext = new MessageContext();
        HttpServletRequest request = this.getHttpServletRequest();
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            throw new MessageDecodingException("This message deocoder only supports the HTTP POST method");
        }
        this.log.debug("Unmarshalling SOAP message");
        try {
            soapMessage = (Envelope)this.unmarshallMessage((InputStream)request.getInputStream());
            ((Soap11Context)messageContext.getSubcontext(Soap11Context.class, true)).setEnvelope(soapMessage);
        }
        catch (IOException e) {
            this.log.error("Unable to obtain input stream from HttpServletRequest", (Throwable)e);
            throw new MessageDecodingException("Unable to obtain input stream from HttpServletRequest", (Exception)e);
        }
        List soapBodyChildren = soapMessage.getBody().getUnknownXMLObjects();
        if (soapBodyChildren.size() < 1 || soapBodyChildren.size() > 1) {
            this.log.error("Unexpected number of children in the SOAP body, " + soapBodyChildren.size() + ".  Unable to extract SAML message");
            throw new MessageDecodingException("Unexpected number of children in the SOAP body, unable to extract SAML message");
        }
        XMLObject incommingMessage = (XMLObject)soapBodyChildren.get(0);
        if (!(incommingMessage instanceof SAMLObject)) {
            this.log.error("Unexpected SOAP body content.  Expected a SAML request but recieved {}", (Object)incommingMessage.getElementQName());
            throw new MessageDecodingException("Unexpected SOAP body content.  Expected a SAML request but recieved " + incommingMessage.getElementQName());
        }
        SAMLObject samlMessage = (SAMLObject)incommingMessage;
        this.log.debug("Decoded SOAP messaged which included SAML message of type {}", (Object)samlMessage.getElementQName());
        messageContext.setMessage((Object)samlMessage);
        this.setMessageContext(messageContext);
    }
}

