/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security;

import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.binding.SAMLMessageContext;
import org.opensaml.util.storage.ReplayCache;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReplayRule
implements SecurityPolicyRule {
    private final Logger log = LoggerFactory.getLogger(MessageReplayRule.class);
    private ReplayCache replayCache;
    private boolean requiredRule;

    public MessageReplayRule(ReplayCache newReplayCache) {
        this.replayCache = newReplayCache;
        this.requiredRule = true;
    }

    public boolean isRequiredRule() {
        return this.requiredRule;
    }

    public void setRequiredRule(boolean required) {
        this.requiredRule = required;
    }

    public void evaluate(MessageContext messageContext) throws SecurityPolicyException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.debug("Invalid message context type, this policy rule only supports SAMLMessageContext");
            return;
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        String messageIsuer = StringSupport.trimOrNull((String)samlMsgCtx.getInboundMessageIssuer());
        if (messageIsuer == null) {
            if (this.requiredRule) {
                this.log.warn("Message contained no Issuer ID, replay check not possible");
                throw new SecurityPolicyException("Message contained no Issuer ID, replay check not possible");
            }
            return;
        }
        String messageId = StringSupport.trimOrNull((String)samlMsgCtx.getInboundSAMLMessageId());
        if (messageId == null) {
            if (this.requiredRule) {
                this.log.warn("Message contained no ID, replay check not possible");
                throw new SecurityPolicyException("SAML message from issuer " + messageIsuer + " did not contain an ID");
            }
            return;
        }
        if (this.replayCache.isReplay(messageIsuer, messageId)) {
            this.log.warn("Replay detected of message '" + messageId + "' from issuer " + messageIsuer);
            throw new SecurityPolicyException("Rejecting replayed message ID '" + messageId + "' from issuer " + messageIsuer);
        }
    }
}

