/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security;

import com.google.common.base.Strings;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.saml.common.binding.SAMLMessageContext;
import org.opensaml.saml.security.MetadataCriterion;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.EntityIDCriterion;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.provider.BaseTrustEngineRule;
import org.opensaml.xmlsec.signature.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSAMLXMLSignatureSecurityPolicyRule
extends BaseTrustEngineRule<Signature> {
    private final Logger log = LoggerFactory.getLogger(BaseSAMLXMLSignatureSecurityPolicyRule.class);

    public BaseSAMLXMLSignatureSecurityPolicyRule(TrustEngine<Signature> engine) {
        super(engine);
    }

    protected CriteriaSet buildCriteriaSet(String entityID, MessageContext messageContext) throws SecurityPolicyException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Supplied message context was not an instance of SAMLMessageContext, can not build criteria set from SAML metadata parameters");
            throw new SecurityPolicyException("Supplied message context was not an instance of SAMLMessageContext");
        }
        SAMLMessageContext samlContext = (SAMLMessageContext)messageContext;
        CriteriaSet criteriaSet = new CriteriaSet();
        if (!Strings.isNullOrEmpty((String)entityID)) {
            criteriaSet.add((Object)new EntityIDCriterion(entityID));
        }
        MetadataCriterion mdCriteria = new MetadataCriterion(samlContext.getPeerEntityRole(), samlContext.getInboundSAMLProtocol());
        criteriaSet.add((Object)mdCriteria);
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        return criteriaSet;
    }
}

