/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support;

import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SecurityConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.crypto.AlgorithmSupport;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignatureSupport {
    private SignatureSupport() {
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SignatureSupport.class);
    }

    public static void prepareSignatureParams(Signature signature, Credential signingCredential, SecurityConfiguration config, String keyInfoGenName) throws SecurityException {
        Logger log = SignatureSupport.getLogger();
        SecurityConfiguration secConfig = config != null ? config : SecurityConfigurationSupport.getGlobalXMLSecurityConfiguration();
        String signAlgo = signature.getSignatureAlgorithm();
        if (signAlgo == null) {
            signAlgo = secConfig.getSignatureAlgorithmURI(signingCredential);
            signature.setSignatureAlgorithm(signAlgo);
        }
        if (AlgorithmSupport.isHMAC(signAlgo) && signature.getHMACOutputLength() == null) {
            signature.setHMACOutputLength(secConfig.getSignatureHMACOutputLength());
        }
        if (signature.getCanonicalizationAlgorithm() == null) {
            signature.setCanonicalizationAlgorithm(secConfig.getSignatureCanonicalizationAlgorithm());
        }
        if (signature.getKeyInfo() == null) {
            KeyInfoGenerator kiGenerator = KeyInfoSupport.getKeyInfoGenerator(signingCredential, secConfig, keyInfoGenName);
            if (kiGenerator != null) {
                try {
                    KeyInfo keyInfo = kiGenerator.generate(signingCredential);
                    signature.setKeyInfo(keyInfo);
                }
                catch (SecurityException e) {
                    log.error("Error generating KeyInfo from credential", (Throwable)e);
                    throw e;
                }
            } else {
                log.info("No factory for named KeyInfoGenerator {} was found for credential type {}", (Object)keyInfoGenName, (Object)signingCredential.getCredentialType().getName());
                log.info("No KeyInfo will be generated for Signature");
            }
        }
    }
}

