/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SecurityConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.encryption.support.EncryptionParameters;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncryptionSupport {
    private EncryptionSupport() {
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(EncryptionSupport.class);
    }

    public static EncryptionParameters buildDataEncryptionParams(Credential encryptionCredential, SecurityConfiguration config, String keyInfoGenName) {
        Logger log = EncryptionSupport.getLogger();
        SecurityConfiguration secConfig = config != null ? config : SecurityConfigurationSupport.getGlobalXMLSecurityConfiguration();
        EncryptionParameters encParams = new EncryptionParameters();
        encParams.setEncryptionCredential(encryptionCredential);
        if (encryptionCredential == null) {
            encParams.setAlgorithm(secConfig.getAutoGeneratedDataEncryptionKeyAlgorithmURI());
        } else {
            encParams.setAlgorithm(secConfig.getDataEncryptionAlgorithmURI(encryptionCredential));
            KeyInfoGenerator kiGenerator = KeyInfoSupport.getKeyInfoGenerator(encryptionCredential, secConfig, keyInfoGenName);
            if (kiGenerator != null) {
                encParams.setKeyInfoGenerator(kiGenerator);
            } else {
                log.info("No factory for named KeyInfoGenerator {} was found for credential type{}", (Object)keyInfoGenName, (Object)encryptionCredential.getCredentialType().getName());
                log.info("No KeyInfo will be generated for EncryptedData");
            }
        }
        return encParams;
    }

    public static KeyEncryptionParameters buildKeyEncryptionParams(Credential encryptionCredential, String wrappedKeyAlgorithm, SecurityConfiguration config, String keyInfoGenName, String recipient) throws SecurityException {
        Logger log = EncryptionSupport.getLogger();
        SecurityConfiguration secConfig = config != null ? config : SecurityConfigurationSupport.getGlobalXMLSecurityConfiguration();
        KeyEncryptionParameters kekParams = new KeyEncryptionParameters();
        kekParams.setEncryptionCredential(encryptionCredential);
        if (encryptionCredential == null) {
            throw new SecurityException("Key encryption credential may not be null");
        }
        kekParams.setAlgorithm(secConfig.getKeyTransportEncryptionAlgorithmURI(encryptionCredential, wrappedKeyAlgorithm));
        KeyInfoGenerator kiGenerator = KeyInfoSupport.getKeyInfoGenerator(encryptionCredential, secConfig, keyInfoGenName);
        if (kiGenerator != null) {
            kekParams.setKeyInfoGenerator(kiGenerator);
        } else {
            log.info("No factory for named KeyInfoGenerator {} was found for credential type {}", (Object)keyInfoGenName, (Object)encryptionCredential.getCredentialType().getName());
            log.info("No KeyInfo will be generated for EncryptedKey");
        }
        kekParams.setRecipient(recipient);
        return kekParams;
    }
}

