/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.xmlsec.encryption.DataReference;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;

public abstract class AbstractEncryptedKeyResolver
implements EncryptedKeyResolver {
    private final List<String> recipients = new ArrayList<String>();

    @Override
    public List<String> getRecipients() {
        return this.recipients;
    }

    protected boolean matchRecipient(String recipient) {
        String trimmedRecipient = StringSupport.trimOrNull((String)recipient);
        if (trimmedRecipient == null || this.recipients.isEmpty()) {
            return true;
        }
        return this.recipients.contains(trimmedRecipient);
    }

    protected boolean matchCarriedKeyName(EncryptedData encryptedData, EncryptedKey encryptedKey) {
        if (encryptedKey.getCarriedKeyName() == null || Strings.isNullOrEmpty((String)encryptedKey.getCarriedKeyName().getValue())) {
            return true;
        }
        if (encryptedData.getKeyInfo() == null || encryptedData.getKeyInfo().getKeyNames().isEmpty()) {
            return false;
        }
        String keyCarriedKeyName = encryptedKey.getCarriedKeyName().getValue();
        List<String> dataKeyNames = KeyInfoSupport.getKeyNames(encryptedData.getKeyInfo());
        return dataKeyNames.contains(keyCarriedKeyName);
    }

    protected boolean matchDataReference(EncryptedData encryptedData, EncryptedKey encryptedKey) {
        if (encryptedKey.getReferenceList() == null || encryptedKey.getReferenceList().getDataReferences().isEmpty()) {
            return true;
        }
        if (Strings.isNullOrEmpty((String)encryptedData.getID())) {
            return false;
        }
        List<DataReference> drlist = encryptedKey.getReferenceList().getDataReferences();
        for (DataReference dr : drlist) {
            if (Strings.isNullOrEmpty((String)dr.getURI()) || !dr.getURI().startsWith("#") || dr.resolveIDFromRoot(dr.getURI().substring(1)) != encryptedData) continue;
            return true;
        }
        return false;
    }
}

