/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.crypto;

import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.SigningUtil;
import org.opensaml.xmlsec.crypto.AlgorithmSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XMLSigningUtil {
    private XMLSigningUtil() {
    }

    public static byte[] signWithURI(Credential signingCredential, String algorithmURI, byte[] input) throws SecurityException {
        String jcaAlgorithmID = AlgorithmSupport.getAlgorithmID(algorithmURI);
        if (jcaAlgorithmID == null) {
            throw new SecurityException("Could not derive JCA algorithm identifier from algorithm URI");
        }
        boolean isHMAC = AlgorithmSupport.isHMAC(algorithmURI);
        return SigningUtil.sign((Credential)signingCredential, (String)jcaAlgorithmID, (boolean)isHMAC, (byte[])input);
    }

    public static boolean verifyWithURI(Credential verificationCredential, String algorithmURI, byte[] signature, byte[] input) throws SecurityException {
        String jcaAlgorithmID = AlgorithmSupport.getAlgorithmID(algorithmURI);
        if (jcaAlgorithmID == null) {
            throw new SecurityException("Could not derive JCA algorithm identifier from algorithm URI");
        }
        boolean isHMAC = AlgorithmSupport.isHMAC(algorithmURI);
        return SigningUtil.verify((Credential)verificationCredential, (String)jcaAlgorithmID, (boolean)isHMAC, (byte[])signature, (byte[])input);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(XMLSigningUtil.class);
    }
}

