/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.ac.impl;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.ac.VOMSACLookupStrategy;
import org.italiangrid.voms.ac.VOMSACValidationStrategy;
import org.italiangrid.voms.ac.VOMSACValidator;
import org.italiangrid.voms.ac.VOMSValidationResult;
import org.italiangrid.voms.ac.ValidationResultListener;
import org.italiangrid.voms.ac.impl.DefaultVOMSACParser;
import org.italiangrid.voms.ac.impl.DefaultVOMSValidationStrategy;
import org.italiangrid.voms.ac.impl.LeafACLookupStrategy;
import org.italiangrid.voms.asn1.VOMSACUtils;
import org.italiangrid.voms.store.UpdatingVOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStores;
import org.italiangrid.voms.util.CertificateValidatorBuilder;
import org.italiangrid.voms.util.NullListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVOMSValidator
extends DefaultVOMSACParser
implements VOMSACValidator {
    public static final String DEFAULT_TRUST_ANCHORS_DIR = "/etc/grid-security/certificates";
    private final VOMSACValidationStrategy validationStrategy;
    private final VOMSTrustStore trustStore;
    private ValidationResultListener validationResultListener;

    private DefaultVOMSValidator(Builder b) {
        super(b.acLookupStrategy);
        this.validationStrategy = b.validationStrategy;
        this.trustStore = b.trustStore;
        this.validationResultListener = b.validationResultListener;
    }

    @Override
    public synchronized List<VOMSValidationResult> validateWithResult(X509Certificate[] validatedChain) {
        this.setCertChain(validatedChain);
        return this.validate();
    }

    protected synchronized List<VOMSValidationResult> validate() {
        List<VOMSAttribute> parsedAttrs = this.parse();
        ArrayList<VOMSValidationResult> results = new ArrayList<VOMSValidationResult>();
        for (VOMSAttribute a : parsedAttrs) {
            VOMSValidationResult result = this.validationStrategy.validateAC(a, this.getCertChain());
            this.validationResultListener.notifyValidationResult(result);
            results.add(result);
        }
        return results;
    }

    @Override
    public synchronized List<VOMSAttribute> validate(X509Certificate[] validatedChain) {
        this.setCertChain(validatedChain);
        ArrayList<VOMSAttribute> validAttributes = new ArrayList<VOMSAttribute>();
        for (VOMSValidationResult result : this.validate()) {
            if (!result.isValid()) continue;
            validAttributes.add(result.getAttributes());
        }
        return validAttributes;
    }

    @Override
    public synchronized void shutdown() {
        if (this.trustStore instanceof UpdatingVOMSTrustStore) {
            ((UpdatingVOMSTrustStore)this.trustStore).cancel();
        }
    }

    @Override
    public synchronized List<AttributeCertificate> validateACs(List<AttributeCertificate> acs) {
        ArrayList<AttributeCertificate> validatedAcs = new ArrayList<AttributeCertificate>();
        for (AttributeCertificate ac : acs) {
            VOMSAttribute vomsAttrs = VOMSACUtils.deserializeVOMSAttributes(ac);
            VOMSValidationResult result = this.validationStrategy.validateAC(vomsAttrs);
            this.validationResultListener.notifyValidationResult(result);
            if (!result.isValid()) continue;
            validatedAcs.add(ac);
        }
        return validatedAcs;
    }

    @Override
    public synchronized void setValidationResultListener(ValidationResultListener listener) {
        if (listener != null) {
            this.validationResultListener = listener;
        }
    }

    public static class Builder {
        private VOMSACValidationStrategy validationStrategy;
        private VOMSTrustStore trustStore;
        private ValidationResultListener validationResultListener;
        private X509CertChainValidatorExt certChainValidator;
        private VOMSACLookupStrategy acLookupStrategy;

        public Builder validationStrategy(VOMSACValidationStrategy s) {
            this.validationStrategy = s;
            return this;
        }

        public Builder trustStore(VOMSTrustStore ts) {
            this.trustStore = ts;
            return this;
        }

        public Builder validationListener(ValidationResultListener l) {
            this.validationResultListener = l;
            return this;
        }

        public Builder certChainValidator(X509CertChainValidatorExt v) {
            this.certChainValidator = v;
            return this;
        }

        public Builder acLookupStrategy(VOMSACLookupStrategy ls) {
            this.acLookupStrategy = ls;
            return this;
        }

        private void sanityChecks() {
            if (this.validationStrategy == null) {
                if (this.trustStore == null) {
                    this.trustStore = VOMSTrustStores.newTrustStore();
                }
                if (this.certChainValidator == null) {
                    this.certChainValidator = CertificateValidatorBuilder.buildCertificateValidator(DefaultVOMSValidator.DEFAULT_TRUST_ANCHORS_DIR);
                }
                this.validationStrategy = new DefaultVOMSValidationStrategy(this.trustStore, this.certChainValidator);
            }
            if (this.validationResultListener == null) {
                this.validationResultListener = NullListener.INSTANCE;
            }
            if (this.acLookupStrategy == null) {
                this.acLookupStrategy = new LeafACLookupStrategy();
            }
        }

        public DefaultVOMSValidator build() {
            this.sanityChecks();
            return new DefaultVOMSValidator(this);
        }
    }
}

