/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.utils.voms;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.italiangrid.utils.voms.VOMSSecurityContext;
import org.italiangrid.voms.VOMSAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSSecurityContextHandler
extends AbstractHandler
implements Handler {
    public static final Logger log = LoggerFactory.getLogger(VOMSSecurityContextHandler.class);

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        VOMSSecurityContext.clearCurrentContext();
        VOMSSecurityContext sc = new VOMSSecurityContext();
        VOMSSecurityContext.setCurrentContext(sc);
        X509Certificate[] certChain = null;
        try {
            certChain = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        }
        catch (Exception e) {
            log.warn("Error fetching certificate from http request: {}", (Object)e.getMessage(), (Object)e);
        }
        if (certChain == null) {
            log.info("Unauthenticated connection from {}", (Object)request.getRemoteAddr());
            return;
        }
        sc.setClientCertChain(certChain);
        BigInteger sn = sc.getClientCert().getSerialNumber();
        String serialNumber = sn == null ? "NULL" : sn.toString();
        List<VOMSAttribute> vomsAttributes = sc.getVOMSAttributes();
        String vomsAttrsString = "No valid VOMS attributes found.";
        vomsAttrsString = String.format("VOMS attributes: %s .", vomsAttributes);
        String connectionMessage = String.format("Connection from '%s' by '%s' (issued by '%s') serial: %s. %s", request.getRemoteAddr(), sc.getClientX500Name(), sc.getIssuerX500Name(), serialNumber, vomsAttrsString);
        log.info(connectionMessage);
    }
}

