/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.io.OutputStream;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.cms.CMSCompressedDataStreamGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEGenerator;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;

public class SMIMECompressedGenerator
extends SMIMEGenerator {
    public static final String ZLIB = "1.2.840.113549.1.9.16.3.8";
    private static final String COMPRESSED_CONTENT_TYPE = "application/pkcs7-mime; name=\"smime.p7z\"; smime-type=compressed-data";

    private MimeBodyPart make(MimeBodyPart mimeBodyPart, String string) throws SMIMEException {
        try {
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            mimeBodyPart2.setContent(new ContentCompressor(mimeBodyPart, string), COMPRESSED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Type", COMPRESSED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7z\"");
            mimeBodyPart2.addHeader("Content-Description", "S/MIME Compressed Message");
            mimeBodyPart2.addHeader("Content-Transfer-Encoding", this.encoding);
            return mimeBodyPart2;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting multi-part together.", messagingException);
        }
    }

    public MimeBodyPart generate(MimeBodyPart mimeBodyPart, String string) throws SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), string);
    }

    public MimeBodyPart generate(MimeMessage mimeMessage, String string) throws SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", messagingException);
        }
        return this.make(this.makeContentBodyPart(mimeMessage), string);
    }

    static {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        CommandMap.setDefaultCommandMap(mailcapCommandMap);
    }

    private class ContentCompressor
    implements SMIMEStreamingProcessor {
        private final MimeBodyPart _content;
        private final String _compressionOid;

        ContentCompressor(MimeBodyPart mimeBodyPart, String string) {
            this._content = mimeBodyPart;
            this._compressionOid = string;
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            CMSCompressedDataStreamGenerator cMSCompressedDataStreamGenerator = new CMSCompressedDataStreamGenerator();
            OutputStream outputStream2 = cMSCompressedDataStreamGenerator.open(outputStream, this._compressionOid);
            try {
                this._content.writeTo(outputStream2);
                outputStream2.close();
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException.toString());
            }
        }
    }
}

