/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.storagearea;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class StorageArea {
    private String name;
    private String FSRoot;
    private String stfnRoot;
    private List<String> protocols;

    public StorageArea(String name, String FSRoot, String stfnRoot, List<String> protocols) {
        this.name = name;
        this.FSRoot = this.normalizePath(FSRoot);
        this.stfnRoot = this.normalizePath(stfnRoot);
        this.protocols = new ArrayList<String>();
        for (String protocol : protocols) {
            this.protocols.add(protocol.toUpperCase());
        }
    }

    public final String getName() {
        return this.name;
    }

    public final List<String> getProtocols() {
        return this.protocols;
    }

    public final String getFSRoot() {
        return this.FSRoot;
    }

    private final String normalizePath(String path) {
        if (path.charAt(path.length() - 1) == File.separatorChar) {
            if (path.charAt(0) != File.separatorChar) {
                return File.separatorChar + path.substring(0, path.length() - 1);
            }
            return path.substring(0, path.length() - 1);
        }
        if (path.charAt(0) != File.separatorChar) {
            return File.separatorChar + path;
        }
        return path;
    }

    public final String getStfnRoot() {
        return this.stfnRoot;
    }

    public String[] getProtocolAsStrArray() {
        String[] out = new String[this.protocols.size()];
        int i = 0;
        for (String protocol : this.protocols) {
            out[i++] = protocol;
        }
        return out;
    }

    public String toString() {
        return "StorageArea [name=" + this.name + ", root=" + this.FSRoot + ", stfnRoot=" + this.stfnRoot + ", protocol=" + this.getProtocols() + "]";
    }

    public boolean isProtocol(String protocol) {
        return this.getProtocols().contains(protocol);
    }

    public String getRealPath(String path) {
        return path.replaceFirst(this.getStfnRoot(), this.getFSRoot()).replace("//", "/");
    }

    public String getStfn(String fsPath) {
        return fsPath.replaceFirst(this.getFSRoot(), this.getStfnRoot()).replace("//", "/");
    }
}

