/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.gridhttps.server.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtils {
    public static boolean deleteDirectory(File path) throws IOException {
        if (!path.exists()) {
            return false;
        }
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileUtils.deleteDirectory(files[i]);
                continue;
            }
            files[i].delete();
        }
        return path.delete();
    }

    public static void copyFile(InputStream in, OutputStream out) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) > 0) {
            out.write(buffer, 0, length);
        }
        in.close();
        out.close();
    }

    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        FileUtils.copyFile(in, out);
    }

    public static void copyFolder(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdirs();
            }
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                FileUtils.copyFolder(srcFile, destFile);
            }
        } else {
            FileUtils.copyFile(src, dest);
        }
    }
}

