/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.gridhttps.server.mapperservlet;

import it.grid.storm.storagearea.StorageArea;
import it.grid.storm.storagearea.StorageAreaManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperServlet
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(MapperServlet.class);
    private static final long serialVersionUID = 293463225950571516L;
    private static final String PATH_PARAMETER_KEY = "path";
    private static final String MAPPER_SERVLET_ENCODING_SCHEME = "UTF-8";

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Serving a mapping request");
        String pathDecoded = this.getDecodedPath(request);
        log.debug("Decoded filePath = " + pathDecoded + " . Retrieving matching StorageArea");
        StorageArea SA = this.getMatchingSA(pathDecoded);
        log.debug("Storage-Area: " + SA);
        String relativeUrl = File.separator + "fileTransfer" + SA.getStfn(pathDecoded);
        log.info("GET-MAPPING: '" + pathDecoded + "' to '" + relativeUrl + "'");
        this.sendResponse(response, relativeUrl);
    }

    @Override
    public void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("HEAD-MAPPING: " + request.getRequestURI());
    }

    private String getDecodedPath(HttpServletRequest request) throws ServletException {
        String pathDecoded;
        String path = request.getParameter(PATH_PARAMETER_KEY);
        try {
            pathDecoded = URLDecoder.decode(path, MAPPER_SERVLET_ENCODING_SCHEME);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unable to decode path parameter. UnsupportedEncodingException : " + e.getMessage());
            throw new ServletException("Unable to decode path parameter", e);
        }
        return pathDecoded;
    }

    private StorageArea getMatchingSA(String pathDecoded) throws ServletException {
        StorageArea SA = null;
        try {
            SA = StorageAreaManager.getMatchingSA(new File(pathDecoded));
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to get matching SA for path " + pathDecoded + ". IllegalArgumentException : " + e.getMessage());
            throw new ServletException("Unable to get matching SA for path " + pathDecoded, e);
        }
        catch (IllegalStateException e) {
            log.error("Unable to get matching SA for path " + pathDecoded + ". IllegalStateException : " + e.getMessage());
            throw new ServletException("Unable to get matching SA for path " + pathDecoded, e);
        }
        if (SA == null) {
            log.error("No matching StorageArea found for path '" + pathDecoded + "' Unable to build http(s) relative path");
            throw new ServletException("No matching StorageArea found for the provided path");
        }
        return SA;
    }

    private void sendResponse(HttpServletResponse response, String message) throws IOException {
        PrintWriter out;
        response.setContentType("text/html");
        try {
            out = response.getWriter();
        }
        catch (IOException e) {
            log.error("Unable to obtain the PrintWriter for the response. IOException: " + e.getMessage());
            throw e;
        }
        out.print(message);
    }
}

