/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.gridhttps.server.data;

import it.grid.storm.gridhttps.server.exceptions.InitException;

public class StormBackend {
    private String hostname;
    private int port;
    private int servicePort;

    public StormBackend(String hostname, int port, int servicePort) {
        this();
        this.setHostname(hostname);
        this.setPort(port);
        this.setServicePort(servicePort);
    }

    public StormBackend() {
        this.setPort(8080);
        this.setServicePort(9998);
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }

    public String toString() {
        return "{'" + this.hostname + "', " + this.port + ", " + this.servicePort + "}";
    }

    public void checkConfiguration() throws InitException {
        if (this.hostname.isEmpty()) {
            throw new InitException("backend hostname is empty!");
        }
        if (this.port <= 0) {
            throw new InitException("backend port is " + this.port + "!");
        }
        if (this.servicePort <= 0) {
            throw new InitException("backend service port is " + this.servicePort + "!");
        }
        if (this.servicePort == this.port) {
            throw new InitException("backend port is equal to service port!");
        }
    }
}

