/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.https.configuration;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configurator {
    private static final int DEFAULT_MAPPING_PORT = 8086;
    private static final String SERVER_USER_UID_KEY = "gridhttps.server.user.uid";
    private static final String SERVER_USER_GID_KEY = "gridhttps.server.user.gid";
    private static final String MAPPING_SERVICE_PORT_KEY = "gridhttps.mapping-service.port";
    private static Logger logger = LoggerFactory.getLogger(Configurator.class);
    private static PropertiesConfiguration config = null;

    public static void init(String propertiesFilePath) throws ConfigurationException {
        logger.debug("Configurator initialization from file " + propertiesFilePath);
        File propertiesFile = new File(propertiesFilePath);
        if (!propertiesFile.exists()) {
            logger.error("The configuration file " + propertiesFile.getAbsolutePath() + " don't exists!");
            throw new ConfigurationException("The configuration file " + propertiesFile.getAbsolutePath() + " don't exists!");
        }
        config = new PropertiesConfiguration(propertiesFile);
        config.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
        logger.debug("Testing the file for all required parameters");
        try {
            Configurator.getServerUserUID();
            Configurator.getServerUserGID();
            Configurator.getMappingPort();
        }
        catch (ConfigurationException e) {
            logger.error("Unable to find all required configuration parameters in the provided configuration file : " + e.getMessage());
            ConfigurationException exception = new ConfigurationException("Unable to find all required configuration parameters in the provided configuration file : " + e.getMessage());
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
        logger.debug("Configurator initialization completed");
    }

    private static void tryReinit() throws ConfigurationException {
        if (config != null && config.getReloadingStrategy().reloadingRequired()) {
            logger.info("Reinitializing the Configurator from the stored configuration file " + config.getFile().getAbsolutePath());
            Configurator.init(config.getFile().getAbsolutePath());
        }
    }

    public static int getServerUserUID() throws ConfigurationException {
        logger.debug("Requested the retrieving of the server user UID");
        Integer uid = null;
        if (config != null) {
            Configurator.tryReinit();
            uid = Configurator.getIntProperty(SERVER_USER_UID_KEY);
            if (uid == null) {
                logger.error("Unable to retrieve a correct server user UID from the configuration file '" + config.getFileName() + "'");
                throw new ConfigurationException("Unable to retrieve a correct server user UID from the configuration file '" + config.getFileName() + "'");
            }
        } else {
            logger.error("Unable to retrieve the server user UID, Configurator not initialized! Do Configurator.init(File propertiesFile) first");
            throw new ConfigurationException("Unable to retrieve the server user UID, Configurator not initialized! Do Configurator.init(File propertiesFile) first");
        }
        return uid;
    }

    public static int getServerUserGID() throws ConfigurationException {
        logger.debug("Requested the retrieving of the server user GID");
        Integer gid = null;
        if (config != null) {
            Configurator.tryReinit();
            gid = Configurator.getIntProperty(SERVER_USER_GID_KEY);
            if (gid == null) {
                logger.error("Unable to retrieve a correct server user GID from the configuration file '" + config.getFileName() + "'");
                throw new ConfigurationException("Unable to retrieve a correct server user GID from the configuration file '" + config.getFileName() + "'");
            }
        } else {
            logger.error("Unable to retrieve the server user GID, Configurator not initialized! Do Configurator.init(File propertiesFile) first");
            throw new ConfigurationException("Unable to retrieve the server user GID, Configurator not initialized! Do Configurator.init(File propertiesFile) first");
        }
        return gid;
    }

    public static int getMappingPort() throws ConfigurationException {
        logger.debug("Requested the retrieving of the server mapping-service port");
        Integer port = null;
        if (config != null) {
            Configurator.tryReinit();
            port = Configurator.getIntProperty(MAPPING_SERVICE_PORT_KEY);
            if (port == null) {
                logger.info("No mapping-service port specified in the configuration file '" + config.getFileName() + "', using default " + 8086);
                port = 8086;
            }
        } else {
            logger.error("Unable to retrieve the mapping-service port, Configurator not initialized! Do Configurator.init(File propertiesFile) first");
            throw new ConfigurationException("Unable to retrieve the mapping-service port, Configurator not initialized! Do Configurator.init(File propertiesFile) first");
        }
        return port;
    }

    private static String getStringProperty(String property) throws ConfigurationException {
        String value = null;
        if (config.containsKey(property)) {
            try {
                value = config.getString(property);
            }
            catch (ConversionException e) {
                logger.error("The string property " + property + " is not correctly specified. ConversionException " + e.getMessage());
                throw new ConfigurationException("The string property " + property + " is not correctly specified");
            }
        }
        if (value == null || value.trim().equals("")) {
            logger.debug("No " + property + " specified in the configuration file '" + config.getFileName() + "'.");
            value = null;
        } else {
            logger.debug("The specified value for property " + property + " is " + value);
        }
        return value;
    }

    private static List<String> getStringListProperty(String property) throws ConfigurationException {
        String[] value = null;
        LinkedList<String> list = null;
        if (config.containsKey(property)) {
            try {
                value = config.getStringArray(property);
            }
            catch (ConversionException e) {
                logger.error("The string property " + property + " is not correctly specified");
                throw new ConfigurationException("The string property " + property + " is not correctly specified");
            }
        }
        list = new LinkedList<String>();
        if (value == null) {
            logger.info("No " + property + " specified in the configuration file '" + config.getFileName() + "'. Returning an empty list");
        } else {
            logger.debug("The specified value for property " + property + " is " + value);
            list = new LinkedList();
            for (String element : value) {
                list.add(element);
            }
        }
        return list;
    }

    private static Integer getIntProperty(String property) throws ConfigurationException {
        Integer value = null;
        if (config.containsKey(property)) {
            try {
                Object propertyValue = config.getProperty(property);
                if (propertyValue.getClass().equals(String.class) && (((String)propertyValue).trim().length() == 0 || ((String)propertyValue).trim().equals(""))) {
                    logger.debug("The numeric string provided by user is an empty string");
                } else {
                    value = config.getInt(property);
                }
            }
            catch (ConversionException e) {
                logger.error("The int property " + property + " is not correctly specified. ConversionException : " + e.getMessage());
                throw new ConfigurationException("The int property " + property + " is not correctly specified");
            }
        }
        if (value == null) {
            logger.info("No " + property + " specified in the configuration file '" + config.getFileName() + "'.");
        } else {
            logger.debug("The specified value for property " + property + " is " + value);
        }
        return value;
    }
}

