/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.https;

import it.grid.storm.filesystem.FilesystemPermission;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.https.HTTPSPluginException;
import it.grid.storm.https.HTTPSPluginInterface;
import it.grid.storm.https.configuration.Configurator;
import it.grid.storm.https.remotecall.GridHttpsServiceConstants;
import it.grid.storm.https.remotecall.MapperServiceConstants;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GhttpsHTTPSPluginInterface
implements HTTPSPluginInterface {
    private final Logger log = LoggerFactory.getLogger(GhttpsHTTPSPluginInterface.class);
    private int serverUserUID;
    private int serverUserGID;
    private int serverMappingPort;
    private LocalUser serverLocalUser;

    public GhttpsHTTPSPluginInterface() throws InstantiationException {
        String configurationFilePath = GridHttpsServiceConstants.CONFIGURATION_FILE_LOCATION_PATH + File.separatorChar + "storm.gridhttps.plugin.properties";
        try {
            Configurator.init(configurationFilePath);
        }
        catch (ConfigurationException e) {
            this.log.error("Unable to initialize the Configurator object! ConfigurationException: " + e.getMessage());
            throw new InstantiationException("Error during Configurator initialization");
        }
        try {
            this.serverUserUID = Configurator.getServerUserUID();
            this.serverUserGID = Configurator.getServerUserGID();
            this.serverMappingPort = Configurator.getMappingPort();
        }
        catch (ConfigurationException e) {
            this.log.error("Unable to get all the mandatory configuration parameters. ConfigurationException: " + e.getMessage());
            throw new InstantiationException("Error during mandatory configuration parameters retrieving");
        }
        this.setLocaUser();
    }

    private void setLocaUser() {
        this.serverLocalUser = new LocalUser(this.serverUserUID, this.serverUserGID);
    }

    public void grantGroupPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) {
        this.grantServiceGroupPermission(localFile, permission);
    }

    public void grantServiceGroupPermission(LocalFile localFile, FilesystemPermission permission) {
        localFile.grantGroupPermission(this.serverLocalUser, permission);
        this.log.debug("Granted group permission " + permission.toString() + " on file " + localFile.toString() + " to service group " + this.serverLocalUser.toString());
    }

    public void grantUserPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) {
        this.grantServiceUserPermission(localFile, permission);
    }

    public void grantServiceUserPermission(LocalFile localFile, FilesystemPermission permission) {
        localFile.grantUserPermission(this.serverLocalUser, permission);
        this.log.debug("Granted user permission " + permission.toString() + " on file " + localFile.toString() + " to service user " + this.serverLocalUser.toString());
    }

    public void removeGroupPermission(LocalFile localFile, LocalUser localUser) {
        localFile.removeGroupPermission(this.serverLocalUser);
        this.log.debug("Removed group permission from file " + localFile.toString() + " to group " + localUser.toString());
    }

    public void removeUserPermission(LocalFile localFile, LocalUser localUser) {
        localFile.removeUserPermission(this.serverLocalUser);
        this.log.debug("Removed user permission from file " + localFile.toString() + " to user " + localUser.toString());
    }

    public void revokeGroupPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) {
        localFile.revokeGroupPermission(this.serverLocalUser, permission);
        this.log.debug("Revoked group permission " + permission.toString() + " from file " + localFile.toString() + " to group " + localUser.toString());
    }

    public void revokeUserPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) {
        localFile.revokeUserPermission(this.serverLocalUser, permission);
        this.log.debug("Revoked user permission " + permission.toString() + " from file " + localFile.toString() + " to user " + localUser.toString());
    }

    public void setGroupPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) {
        localFile.setGroupPermission(this.serverLocalUser, permission);
        this.log.debug("Setted group permission " + permission.toString() + " on file " + localFile.toString() + " to group " + localUser.toString());
    }

    public void setUserPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) {
        localFile.setUserPermission(this.serverLocalUser, permission);
        this.log.debug("Setted user permission " + permission.toString() + " on file " + localFile.toString() + " to user " + localUser.toString());
    }

    public void removeAllPermissions(LocalFile localFile) {
        localFile.removeGroupPermission(this.serverLocalUser);
        localFile.removeUserPermission(this.serverLocalUser);
        this.log.debug("Removing all permissions from file " + localFile.toString());
    }

    public void moveAllPermissions(LocalFile fromLocalFile, LocalFile toLocalFile) {
        this.log.debug("Permissions moving, from file " + fromLocalFile.toString() + " to file " + toLocalFile.toString() + " . Nothing to do, permissions are moved with the file");
    }

    public String mapLocalPath(String serverHost, String localAbsolutePath) throws HTTPSPluginException {
        HttpResponse httpResponse;
        this.log.debug("Mapping local path " + localAbsolutePath + " to gridhttp relative URL");
        URI uri = this.buildMapperServiceUri(serverHost, localAbsolutePath);
        this.log.debug("Mapping Service call uri = " + uri.toString());
        HttpGet httpget = new HttpGet(uri);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            httpResponse = httpclient.execute((HttpUriRequest)httpget);
        }
        catch (ClientProtocolException e) {
            this.log.error("Error executing http call. ClientProtocolException " + e.getLocalizedMessage());
            throw new HTTPSPluginException("Error contacting Mapping Service.");
        }
        catch (IOException e) {
            this.log.error("Error executing http call. IOException " + e.getLocalizedMessage());
            throw new HTTPSPluginException("Error contacting Mapping Service.");
        }
        StatusLine status = httpResponse.getStatusLine();
        if (status == null) {
            this.log.error("Unexpected error! response.getStatusLine() returned null!");
            throw new HTTPSPluginException("Unexpected error! response.getStatusLine() returned null! Please contact storm support");
        }
        int httpCode = status.getStatusCode();
        String httpMessage = status.getReasonPhrase();
        HttpEntity entity = httpResponse.getEntity();
        String output = "";
        if (entity != null) {
            InputStream responseIS;
            try {
                responseIS = entity.getContent();
            }
            catch (IllegalStateException e) {
                this.log.error("Unable to get the input content stream from server answer. IllegalStateException " + e.getLocalizedMessage());
                throw new HTTPSPluginException("Error comunicationg with the Mapping Service.");
            }
            catch (IOException e) {
                this.log.error("Unable to get the input content stream from server answer. IOException " + e.getLocalizedMessage());
                throw new HTTPSPluginException("Error comunicationg with the Mapping Servicee.");
            }
            byte[] tmp = new byte[1024];
            try {
                int l;
                while ((l = responseIS.read(tmp)) != -1) {
                    output = output + new String(tmp, 0, l);
                }
            }
            catch (IOException e) {
                this.log.error("Error reading from the connection error stream. IOException " + e.getMessage());
                throw new HTTPSPluginException("Error comunicationg with the Mapping Service.");
            }
        }
        this.log.error("No HttpEntity found in the response. Unable to determine the answer");
        throw new HTTPSPluginException("Unable to get a valid Mapping response from the server.");
        this.log.debug("Mapping Service response is : '" + output + "'");
        if (httpCode != 200) {
            this.log.error("Unable to get a valid response from server. Received a non HTTP 200 response from the server : '" + httpCode + "' " + httpMessage);
            throw new HTTPSPluginException("Unable to get a valid response from server. " + httpMessage);
        }
        String URLPath = GhttpsHTTPSPluginInterface.decodeHttpsPath(output);
        this.log.info("Mapped local absolute path '" + localAbsolutePath + "' to '" + URLPath + "' gridhttp relative URL");
        return URLPath;
    }

    private URI buildMapperServiceUri(String serverHost, String localAbsolutePath) throws HTTPSPluginException {
        URI uri;
        this.log.debug("Encoding parameters");
        ArrayList<BasicNameValuePair> qparams = new ArrayList<BasicNameValuePair>();
        qparams.add(new BasicNameValuePair("path", localAbsolutePath));
        try {
            uri = new URI("http", null, serverHost, this.serverMappingPort, MapperServiceConstants.SERVICE_PATH, URLEncodedUtils.format(qparams, (String)"UTF-8"), null);
        }
        catch (URISyntaxException e) {
            this.log.error("Unable to create Mapper Service URI. URISyntaxException " + e.getLocalizedMessage());
            throw new HTTPSPluginException("Unable to create Mapper Service URI");
        }
        return uri;
    }

    private static String decodeHttpsPath(String output) {
        String httpsPath = "";
        httpsPath = output.trim();
        return httpsPath;
    }

    public HTTPSPluginInterface.ServiceStatus getServiceStatus(String hostname, int port, HTTPSPluginInterface.Protocol protocol) throws HTTPSPluginException {
        HttpResponse httpResponse;
        URI uri;
        this.log.debug("Checking server status for : " + protocol + hostname + ":" + port);
        switch (protocol) {
            case HTTP: {
                try {
                    uri = new URI(protocol.name().toLowerCase(), null, hostname, port, "/", null, null);
                    break;
                }
                catch (URISyntaxException e) {
                    this.log.error("Unable to create Server root URI. URISyntaxException " + e.getLocalizedMessage());
                    throw new HTTPSPluginException("Unable to create Server root URI");
                }
            }
            case HTTPS: {
                try {
                    uri = new URI("http", null, hostname, this.serverMappingPort, MapperServiceConstants.SERVICE_PATH, null, null);
                    break;
                }
                catch (URISyntaxException e) {
                    this.log.error("Unable to create Server root URI. URISyntaxException " + e.getLocalizedMessage());
                    throw new HTTPSPluginException("Unable to create Server root URI");
                }
            }
            default: {
                this.log.error("Unable to build a service stastus uri for the unmanaged protocol " + protocol);
                throw new HTTPSPluginException("Unmanaged protocol " + protocol);
            }
        }
        this.log.debug("Server root uri = " + uri.toString());
        HttpHead httphead = new HttpHead(uri);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            httpResponse = httpclient.execute((HttpUriRequest)httphead);
        }
        catch (ClientProtocolException e) {
            this.log.error("Error executing http call. ClientProtocolException " + e.getLocalizedMessage());
            throw new HTTPSPluginException("Error contacting Mapping Service.");
        }
        catch (IOException e) {
            this.log.error("Error executing http call. IOException " + e.getLocalizedMessage());
            return HTTPSPluginInterface.ServiceStatus.NOT_RESPONDING;
        }
        StatusLine status = httpResponse.getStatusLine();
        if (status == null) {
            this.log.error("Unexpected error! response.getStatusLine() returned null!");
            throw new HTTPSPluginException("Unexpected error! response.getStatusLine() returned null! Please contact StoRM support");
        }
        int httpCode = status.getStatusCode();
        if (httpCode == 200) {
            return HTTPSPluginInterface.ServiceStatus.RUNNING;
        }
        return HTTPSPluginInterface.ServiceStatus.UNEXPECTED_BEHAVIOUR;
    }
}

