/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.ByteRange;
import org.globus.ftp.Marker;

public class GridFTPRestartMarker
implements Marker {
    private static Log logger = LogFactory.getLog((class$org$globus$ftp$GridFTPRestartMarker == null ? (class$org$globus$ftp$GridFTPRestartMarker = GridFTPRestartMarker.class$("org.globus.ftp.GridFTPRestartMarker")) : class$org$globus$ftp$GridFTPRestartMarker).getName());
    Vector vector = new Vector();
    static /* synthetic */ Class class$org$globus$ftp$GridFTPRestartMarker;

    public GridFTPRestartMarker(String msg) throws IllegalArgumentException {
        StringTokenizer tokens = new StringTokenizer(msg);
        if (!tokens.hasMoreTokens()) {
            this.badMsg("message empty", msg);
        }
        if (!tokens.nextToken(" ").equals("Range")) {
            this.badMsg("should start with Range Marker", msg);
        }
        if (!tokens.nextToken(" ").equals("Marker")) {
            this.badMsg("should start with Range Marker", msg);
        }
        while (tokens.hasMoreTokens()) {
            long from = 0L;
            long to = 0L;
            try {
                String rangeStr = tokens.nextToken(",");
                StringTokenizer rangeTok = new StringTokenizer(rangeStr, "-");
                from = Long.parseLong(rangeTok.nextToken().trim());
                to = Long.parseLong(rangeTok.nextToken().trim());
                if (rangeTok.hasMoreElements()) {
                    this.badMsg("A range is followed by '-'", msg);
                }
            }
            catch (NoSuchElementException nse) {
                this.badMsg("one of the ranges is malformatted", msg);
            }
            catch (NumberFormatException nfe) {
                this.badMsg("one of the integers is malformatted", msg);
            }
            try {
                this.vector.add(new ByteRange(from, to));
            }
            catch (IllegalArgumentException iae) {
                this.badMsg("range beginning > range end", msg);
            }
        }
        if (this.vector.size() == 0) {
            this.badMsg("empty range list", msg);
        }
    }

    private void badMsg(String why, String msg) {
        throw new IllegalArgumentException("argument is not FTP 111 reply message (" + why + ": ->" + msg + "<-");
    }

    public Vector toVector() {
        return this.vector;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

