/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.webserver;

import com.sun.grizzly.Controller;
import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.comet.CometAsyncFilter;
import com.sun.grizzly.cometd.standalone.CometdAdapter;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.grizzly.standalone.StandaloneMainUtil;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapterChain;
import com.sun.grizzly.util.ClassLoaderUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;

public class WebServer
extends StandaloneMainUtil {
    static int port = 8080;
    private String applicationLoc;
    private String servletClassName;
    private static Logger logger = Controller.logger();

    public static void main(String[] args) throws Exception {
        WebServer main = new WebServer();
        main.start(args);
    }

    public SelectorThread createSelectorThread(String[] args) throws Exception {
        SelectorThread st = super.createSelectorThread(args);
        st.setEnableAsyncExecution(true);
        DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
        asyncHandler.addAsyncFilter(new CometAsyncFilter());
        st.setAsyncHandler(asyncHandler);
        logger.log(Level.INFO, "Starting Grizzly WebServer with support for Comet, Bayeux, Servlet and Static Resources");
        return st;
    }

    public void printHelpAndExit() {
        logger.severe("Usage: " + WebServer.class.getCanonicalName() + " [options]");
        logger.severe("\n");
        logger.severe("    -p, --port=port                  Runs WebServer on the specified port.");
        logger.severe("                                     Default: 8080");
        logger.severe("    -a, --apps=application path      The static resource folder or jar or war location.");
        logger.severe("                                     Default: .");
        logger.severe("    -h, --help                       Show this help message.");
        System.exit(1);
    }

    public boolean parseOptions(String[] args) {
        for (int i = 0; i < args.length - 1; ++i) {
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                this.printHelpAndExit();
                continue;
            }
            if ("-a".equals(arg)) {
                this.applicationLoc = args[++i];
                continue;
            }
            if (arg.startsWith("--application=")) {
                this.applicationLoc = arg.substring("--application=".length(), arg.length());
                continue;
            }
            if ("-p".equals(arg)) {
                this.setPort(args[++i]);
                continue;
            }
            if (!arg.startsWith("--port=")) continue;
            String num = arg.substring("--port=".length(), arg.length());
            this.setPort(num);
        }
        if (this.applicationLoc == null) {
            logger.severe("Illegal War|Jar file or folder location.");
            this.printHelpAndExit();
        }
        if (args.length > 4) {
            this.servletClassName = args[args.length - 1];
        }
        return true;
    }

    public Adapter configureAdapter(SelectorThread st) {
        GrizzlyAdapterChain adapter = new GrizzlyAdapterChain();
        if (this.servletClassName != null) {
            ServletAdapter sa = new ServletAdapter();
            Servlet servlet = (Servlet)ClassLoaderUtil.load(this.servletClassName);
            String urlName = this.servletClassName.substring(this.servletClassName.lastIndexOf(".") + 1);
            logger.info("Servlet requests will be serviced from http://host:port/" + urlName);
            sa.setContextPath("/" + urlName);
            sa.setHandleStaticResources(true);
            sa.setRootFolder(SelectorThread.getWebAppRootPath());
            if (servlet == null) {
                throw new IllegalStateException("Invalid Servlet ClassName");
            }
            sa.setServletInstance(servlet);
            adapter.addGrizzlyAdapter(sa, new String[]{"/" + urlName});
        }
        adapter.addGrizzlyAdapter(new CometdAdapter(), new String[]{"/cometd"});
        return adapter;
    }

    public String parseApplicationLocation(String[] args) {
        return this.applicationLoc;
    }
}

