/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd.standalone;

import com.sun.grizzly.Controller;
import com.sun.grizzly.cometd.BayeuxParser;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.EventRouter;
import com.sun.grizzly.cometd.EventRouterImpl;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

public class CometdAdapter
extends GrizzlyAdapter {
    private String contextPath = "/cometd/cometd";
    private final BayeuxParser bayeuxParser = new BayeuxParser();
    private final EventRouter eventRouter = new EventRouterImpl(this.bayeuxParser);
    public static final String COMETD_REQUEST = "request";
    public static final String COMETD_RESPONSE = "response";

    public CometdAdapter() {
        this.setHandleStaticResources(true);
    }

    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        try {
            CometdRequest cometdReq = (CometdRequest)request.getNote(COMETD_REQUEST);
            CometdResponse cometdRes = (CometdResponse)request.getNote(COMETD_RESPONSE);
            if (cometdReq == null) {
                cometdReq = new CometdRequest<GrizzlyRequest>(request){

                    @Override
                    public String[] getParameterValues(String s) {
                        return ((GrizzlyRequest)this.request).getParameterValues(s);
                    }

                    @Override
                    public int getRemotePort() {
                        return ((GrizzlyRequest)this.request).getRemotePort();
                    }

                    @Override
                    public String getCharacterEncoding() {
                        return ((GrizzlyRequest)this.request).getCharacterEncoding();
                    }

                    @Override
                    public int getContentLength() {
                        return ((GrizzlyRequest)this.request).getContentLength();
                    }

                    @Override
                    public String getContentType() {
                        return ((GrizzlyRequest)this.request).getContentType();
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return ((GrizzlyRequest)this.request).getInputStream();
                    }
                };
                request.setNote(COMETD_REQUEST, cometdReq);
            } else {
                cometdReq.setRequest(request);
            }
            if (cometdRes == null) {
                cometdRes = new CometdResponse<GrizzlyResponse>(response){

                    @Override
                    public void write(String s) throws IOException {
                        ((GrizzlyResponse)this.response).getWriter().write(s);
                    }

                    @Override
                    public void flush() throws IOException {
                        ((GrizzlyResponse)this.response).getWriter().flush();
                    }

                    @Override
                    public void setContentType(String s) {
                        ((GrizzlyResponse)this.response).setContentType(s);
                    }
                };
                request.setNote(COMETD_RESPONSE, cometdRes);
            } else {
                cometdRes.setResponse(response);
            }
            this.eventRouter.route(cometdReq, cometdRes);
        }
        catch (IOException ex) {
            response.setStatus(404);
            Controller.logger().log(Level.FINE, "CometdAdapter exception", ex);
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }
}

