/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.util.ClassPath;
import com.sun.org.apache.bcel.internal.util.ClassQueue;
import com.sun.org.apache.bcel.internal.util.ClassVector;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public abstract class Repository {
    private static ClassPath class_path = new ClassPath();
    private static HashMap classes;
    private static JavaClass OBJECT;

    public static JavaClass lookupClass(String class_name) {
        if (class_name == null || class_name.equals("")) {
            throw new RuntimeException("Invalid class name");
        }
        JavaClass clazz = (JavaClass)classes.get(class_name = class_name.replace('/', '.'));
        if (clazz == null) {
            try {
                InputStream is = class_path.getInputStream(class_name);
                clazz = new ClassParser(is, class_name).parse();
                class_name = clazz.getClassName();
            }
            catch (IOException e) {
                return null;
            }
            classes.put(class_name, clazz);
        }
        return clazz;
    }

    public static ClassPath.ClassFile lookupClassFile(String class_name) {
        try {
            return class_path.getClassFile(class_name);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void clearCache() {
        classes = new HashMap();
        OBJECT = Repository.lookupClass("java.lang.Object");
        if (OBJECT == null) {
            System.err.println("Warning: java.lang.Object not found on CLASSPATH!");
        } else {
            classes.put("java.lang.Object", OBJECT);
        }
    }

    public static JavaClass addClass(JavaClass clazz) {
        String name = clazz.getClassName();
        JavaClass cl = (JavaClass)classes.get(name);
        if (cl == null) {
            cl = clazz;
            classes.put(name, cl);
        }
        return cl;
    }

    public static void removeClass(String clazz) {
        classes.remove(clazz);
    }

    public static void removeClass(JavaClass clazz) {
        Repository.removeClass(clazz.getClassName());
    }

    private static final JavaClass getSuperClass(JavaClass clazz) {
        if (clazz == OBJECT) {
            return null;
        }
        return Repository.lookupClass(clazz.getSuperclassName());
    }

    public static JavaClass[] getSuperClasses(JavaClass clazz) {
        ClassVector vec = new ClassVector();
        clazz = Repository.getSuperClass(clazz);
        while (clazz != null) {
            vec.addElement(clazz);
            clazz = Repository.getSuperClass(clazz);
        }
        return vec.toArray();
    }

    public static JavaClass[] getSuperClasses(String class_name) {
        JavaClass jc = Repository.lookupClass(class_name);
        return jc == null ? null : Repository.getSuperClasses(jc);
    }

    public static JavaClass[] getInterfaces(JavaClass clazz) {
        ClassVector vec = new ClassVector();
        ClassQueue queue = new ClassQueue();
        queue.enqueue(clazz);
        while (!queue.empty()) {
            clazz = queue.dequeue();
            String s = clazz.getSuperclassName();
            String[] interfaces = clazz.getInterfaceNames();
            if (clazz.isInterface()) {
                vec.addElement(clazz);
            } else if (!s.equals("java.lang.Object")) {
                queue.enqueue(Repository.lookupClass(s));
            }
            for (int i = 0; i < interfaces.length; ++i) {
                queue.enqueue(Repository.lookupClass(interfaces[i]));
            }
        }
        return vec.toArray();
    }

    public static JavaClass[] getInterfaces(String class_name) {
        return Repository.getInterfaces(Repository.lookupClass(class_name));
    }

    public static boolean instanceOf(JavaClass clazz, JavaClass super_class) {
        if (clazz == super_class) {
            return true;
        }
        JavaClass[] super_classes = Repository.getSuperClasses(clazz);
        for (int i = 0; i < super_classes.length; ++i) {
            if (super_classes[i] != super_class) continue;
            return true;
        }
        if (super_class.isInterface()) {
            return Repository.implementationOf(clazz, super_class);
        }
        return false;
    }

    public static boolean instanceOf(String clazz, String super_class) {
        return Repository.instanceOf(Repository.lookupClass(clazz), Repository.lookupClass(super_class));
    }

    public static boolean instanceOf(JavaClass clazz, String super_class) {
        return Repository.instanceOf(clazz, Repository.lookupClass(super_class));
    }

    public static boolean instanceOf(String clazz, JavaClass super_class) {
        return Repository.instanceOf(Repository.lookupClass(clazz), super_class);
    }

    public static boolean implementationOf(JavaClass clazz, JavaClass inter) {
        if (clazz == inter) {
            return true;
        }
        JavaClass[] super_interfaces = Repository.getInterfaces(clazz);
        for (int i = 0; i < super_interfaces.length; ++i) {
            if (super_interfaces[i] != inter) continue;
            return true;
        }
        return false;
    }

    public static boolean implementationOf(String clazz, String inter) {
        return Repository.implementationOf(Repository.lookupClass(clazz), Repository.lookupClass(inter));
    }

    public static boolean implementationOf(JavaClass clazz, String inter) {
        return Repository.implementationOf(clazz, Repository.lookupClass(inter));
    }

    public static boolean implementationOf(String clazz, JavaClass inter) {
        return Repository.implementationOf(Repository.lookupClass(clazz), inter);
    }

    static {
        Repository.clearCache();
    }
}

