/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.StackTraceElementProxy;
import java.io.Serializable;

public class ThrowableDataPoint
implements Serializable {
    private static final long serialVersionUID = -2891376879381358469L;
    String rawString;
    StackTraceElementProxy step;
    final ThrowableDataPointType type;

    public ThrowableDataPoint(String rawString) {
        this.rawString = rawString;
        this.type = ThrowableDataPointType.RAW;
    }

    public ThrowableDataPoint(StackTraceElement ste) {
        this.step = new StackTraceElementProxy(ste);
        this.type = ThrowableDataPointType.STEP;
    }

    public ThrowableDataPointType getType() {
        return this.type;
    }

    public StackTraceElementProxy getStackTraceElementProxy() {
        return this.step;
    }

    public String toString() {
        switch (this.type) {
            case RAW: {
                return this.rawString;
            }
            case STEP: {
                return this.step.getSTEAsString();
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    public int hashCode() {
        switch (this.type) {
            case RAW: {
                return this.rawString.hashCode();
            }
            case STEP: {
                return this.step.hashCode();
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThrowableDataPoint other = (ThrowableDataPoint)obj;
        switch (this.type) {
            case RAW: {
                if (this.rawString == null) {
                    return other.rawString == null;
                }
                return this.rawString.equals(other.rawString);
            }
            case STEP: {
                return this.step.equals(other.step);
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThrowableDataPointType {
        RAW,
        STEP;

    }
}

