/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.space;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.ArrayOfTExtraInfo;
import it.grid.storm.srm.types.InvalidArrayOfTExtraInfoAttributeException;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TRetentionPolicyInfo;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.space.AnonymousReserveSpaceInputData;
import it.grid.storm.synchcall.data.space.IdentityReserveSpaceInputData;
import it.grid.storm.synchcall.data.space.ReserveSpaceOutputData;
import it.grid.storm.xmlrpc.converter.Converter;
import it.grid.storm.xmlrpc.converter.ParameterDisplayHelper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReserveSpaceConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(ReserveSpaceConverter.class);

    public InputData convertToInputData(Map inputParam) {
        ArrayOfTExtraInfo storageSystemInfo;
        log.debug("reserveSpaceConverter :Call received :Creation of SpaceResData = " + inputParam.size());
        log.debug("reserveSpaceConverter: Input Structure toString: " + ParameterDisplayHelper.display(inputParam));
        String memberName = null;
        GridUserInterface guser = GridUserManager.decode(inputParam);
        memberName = new String("authorizationID");
        String authID = (String)inputParam.get(memberName);
        memberName = new String("userSpaceTokenDescription");
        String spaceAlias = (String)inputParam.get(memberName);
        if (spaceAlias == null) {
            spaceAlias = new String("");
        }
        TRetentionPolicyInfo retentionPolicyInfo = TRetentionPolicyInfo.decode(inputParam, TRetentionPolicyInfo.PNAME_retentionPolicyInfo);
        TSizeInBytes desiredSizeOfTotalSpace = TSizeInBytes.decode(inputParam, TSizeInBytes.PNAME_DESIREDSIZEOFTOTALSPACE);
        TSizeInBytes desiredSizeOfGuaranteedSpace = TSizeInBytes.decode(inputParam, TSizeInBytes.PNAME_DESIREDSIZEOFGUARANTEEDSPACE);
        try {
            storageSystemInfo = ArrayOfTExtraInfo.decode(inputParam, ArrayOfTExtraInfo.PNAME_STORAGESYSTEMINFO);
        }
        catch (InvalidArrayOfTExtraInfoAttributeException e) {
            storageSystemInfo = null;
        }
        AnonymousReserveSpaceInputData inputData = guser != null ? new IdentityReserveSpaceInputData(guser, spaceAlias, retentionPolicyInfo, desiredSizeOfTotalSpace, desiredSizeOfGuaranteedSpace, storageSystemInfo) : new AnonymousReserveSpaceInputData(spaceAlias, retentionPolicyInfo, desiredSizeOfTotalSpace, desiredSizeOfGuaranteedSpace, storageSystemInfo);
        TLifeTimeInSeconds desiredLifetimeOfReservedSpace = TLifeTimeInSeconds.decode(inputParam, TLifeTimeInSeconds.PNAME_DESIREDLIFETIMEOFRESERVEDSPACE);
        if (desiredLifetimeOfReservedSpace != null && !desiredLifetimeOfReservedSpace.isEmpty()) {
            inputData.setSpaceLifetime(desiredLifetimeOfReservedSpace);
        }
        return inputData;
    }

    public Map convertFromOutputData(OutputData data) {
        TSpaceToken spaceToken;
        TLifeTimeInSeconds lifetimeOfReservedSpace;
        TSizeInBytes sizeOfGuaranteedReservedSpace;
        TSizeInBytes sizeOfTotalReservedSpace;
        log.debug("reserveSpaceConverter :Call received :Creation of XMLRPC Output Structure! ");
        HashMap outputParam = new HashMap();
        ReserveSpaceOutputData outputData = (ReserveSpaceOutputData)data;
        TReturnStatus returnStatus = outputData.getStatus();
        returnStatus.encode(outputParam, "returnStatus");
        TRetentionPolicyInfo retentionPolicyInfo = outputData.getRetentionPolicyInfo();
        if (retentionPolicyInfo != null) {
            retentionPolicyInfo.encode(outputParam, TRetentionPolicyInfo.PNAME_retentionPolicyInfo);
        }
        if ((sizeOfTotalReservedSpace = outputData.getTotalSize()) != null && !sizeOfTotalReservedSpace.isEmpty()) {
            sizeOfTotalReservedSpace.encode(outputParam, TSizeInBytes.PNAME_SIZEOFTOTALRESERVEDSPACE);
        }
        if ((sizeOfGuaranteedReservedSpace = outputData.getGuaranteedSize()) != null && !sizeOfGuaranteedReservedSpace.isEmpty()) {
            sizeOfGuaranteedReservedSpace.encode(outputParam, TSizeInBytes.PNAME_SIZEOFGUARANTEEDRESERVEDSPACE);
        }
        if ((lifetimeOfReservedSpace = outputData.getLifeTimeInSeconds()) != null && !lifetimeOfReservedSpace.isEmpty()) {
            lifetimeOfReservedSpace.encode(outputParam, TLifeTimeInSeconds.PNAME_LIFETIMEOFRESERVEDSPACE);
        }
        if ((spaceToken = outputData.getSpaceToken()) != null) {
            spaceToken.encode(outputParam, TSpaceToken.PNAME_SPACETOKEN);
        }
        log.debug(((Object)outputParam).toString());
        return outputParam;
    }
}

