/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.space;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.space.AnonymousReleaseSpaceInputData;
import it.grid.storm.synchcall.data.space.IdentityReleaseSpaceInputData;
import it.grid.storm.synchcall.data.space.ReleaseSpaceOutputData;
import it.grid.storm.xmlrpc.converter.Converter;
import it.grid.storm.xmlrpc.converter.ParameterDisplayHelper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseSpaceConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(ReleaseSpaceConverter.class);

    public InputData convertToInputData(Map inputParam) {
        log.debug("ReleaseSpaceConverter :Call received :Creation of SpaceResData = " + inputParam.size());
        log.debug("ReleaseSpaceConverter: Input Structure toString: " + ParameterDisplayHelper.display(inputParam));
        GridUserInterface guser = GridUserManager.decode(inputParam);
        TSpaceToken spaceToken = TSpaceToken.decode(inputParam, TSpaceToken.PNAME_SPACETOKEN);
        Boolean force = (Boolean)inputParam.get("forceFileRelease");
        if (force == null) {
            force = new Boolean(false);
        }
        AnonymousReleaseSpaceInputData inputData = guser != null ? new IdentityReleaseSpaceInputData(guser, spaceToken, (boolean)force) : new AnonymousReleaseSpaceInputData(spaceToken, (boolean)force);
        return inputData;
    }

    public Map convertFromOutputData(OutputData data) {
        log.debug("releaseSpaceConverter :Call received :Creation of XMLRPC Output Structure! ");
        ReleaseSpaceOutputData outputData = (ReleaseSpaceOutputData)data;
        HashMap outputParam = new HashMap();
        TReturnStatus returnStatus = outputData.getStatus();
        returnStatus.encode(outputParam, "returnStatus");
        return outputParam;
    }
}

