/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.space;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.ArrayOfTSpaceToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.space.AnonymousGetSpaceTokensInputData;
import it.grid.storm.synchcall.data.space.GetSpaceTokensOutputData;
import it.grid.storm.synchcall.data.space.IdentityGetSpaceTokensInputData;
import it.grid.storm.xmlrpc.converter.Converter;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSpaceTokensConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(GetSpaceTokensConverter.class);

    public InputData convertToInputData(Map inputParam) {
        String memberName = new String("authorizationID");
        GridUserInterface guser = GridUserManager.decode(inputParam);
        String authID = (String)inputParam.get(memberName);
        memberName = new String("userSpaceTokenDescription");
        String userSpaceTokenDescription = (String)inputParam.get(memberName);
        AnonymousGetSpaceTokensInputData inputData = guser != null ? new IdentityGetSpaceTokensInputData(guser, userSpaceTokenDescription) : new AnonymousGetSpaceTokensInputData(userSpaceTokenDescription);
        return inputData;
    }

    public Map convertFromOutputData(OutputData data) {
        ArrayOfTSpaceToken arrayOfSpaceTokens;
        log.debug("GetSpaceTokensConverter. Creation of XMLRPC Output Structure! ");
        Hashtable outputParam = new Hashtable();
        GetSpaceTokensOutputData outputData = (GetSpaceTokensOutputData)data;
        TReturnStatus returnStatus = outputData.getStatus();
        if (returnStatus != null) {
            returnStatus.encode(outputParam, "returnStatus");
        }
        if ((arrayOfSpaceTokens = outputData.getArrayOfSpaceTokens()) != null) {
            arrayOfSpaceTokens.encode(outputParam, "arrayOfSpaceTokens");
        }
        log.debug("Sending: " + outputParam.toString());
        return outputParam;
    }
}

