/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.directory;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.ArrayOfSURLs;
import it.grid.storm.srm.types.ArrayOfTSURLReturnStatus;
import it.grid.storm.srm.types.InvalidArrayOfSURLsAttributeException;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.directory.AnonymousRmInputData;
import it.grid.storm.synchcall.data.directory.IdentityRmInputData;
import it.grid.storm.synchcall.data.directory.RmOutputData;
import it.grid.storm.xmlrpc.converter.Converter;
import it.grid.storm.xmlrpc.converter.ParameterDisplayHelper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(RmConverter.class);

    public InputData convertToInputData(Map inputParam) {
        log.debug("RmConverter :Call received :Creation of RmdirInputData = " + inputParam.size());
        log.debug("RmConverter: Input Structure toString: " + ParameterDisplayHelper.display(inputParam));
        GridUserInterface guser = GridUserManager.decode(inputParam);
        ArrayOfSURLs surlArray = null;
        try {
            surlArray = ArrayOfSURLs.decode(inputParam, "arrayOfSURLs");
        }
        catch (InvalidArrayOfSURLsAttributeException e1) {
            e1.printStackTrace();
        }
        AnonymousRmInputData inputData = guser != null ? new IdentityRmInputData(guser, surlArray) : new AnonymousRmInputData(surlArray);
        log.debug("RmInputData Created!");
        return inputData;
    }

    public Map convertFromOutputData(OutputData outputData) {
        ArrayOfTSURLReturnStatus surlArray;
        log.debug("RmConverter :Call received :Creation of XMLRPC Output Structure! ");
        HashMap outputParam = new HashMap();
        RmOutputData rmOutputData = (RmOutputData)outputData;
        TReturnStatus status = rmOutputData.getStatus();
        if (status != null) {
            status.encode(outputParam, "returnStatus");
        }
        if ((surlArray = rmOutputData.getSurlStatus()) != null) {
            surlArray.encode(outputParam, ArrayOfTSURLReturnStatus.PNAME_ARRAYOFFILESTATUSES);
        }
        return outputParam;
    }
}

