/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.directory;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.directory.AnonymousMvInputData;
import it.grid.storm.synchcall.data.directory.IdentityMvInputData;
import it.grid.storm.synchcall.data.directory.MvOutputData;
import it.grid.storm.xmlrpc.converter.Converter;
import it.grid.storm.xmlrpc.converter.ParameterDisplayHelper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MvConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(MvConverter.class);

    public InputData convertToInputData(Map inputParam) {
        log.debug("SrmMv: Converter :Call received :Creation of MvInputData = " + inputParam.size());
        log.debug("SrmMv: Converter: Input Structure toString: " + ParameterDisplayHelper.display(inputParam));
        GridUserInterface guser = GridUserManager.decode(inputParam);
        TSURL fromSURL = null;
        try {
            fromSURL = TSURL.decode(inputParam, "fromSURL");
        }
        catch (InvalidTSURLAttributesException e1) {
            log.debug("SrmMv: ErrorCreating surl: " + e1.toString());
        }
        TSURL toSURL = null;
        try {
            toSURL = TSURL.decode(inputParam, "toSURL");
        }
        catch (InvalidTSURLAttributesException e1) {
            log.debug("SrmMv: ErrorCreating surl: " + e1.toString());
        }
        AnonymousMvInputData inputData = guser != null ? new IdentityMvInputData(guser, fromSURL, toSURL) : new AnonymousMvInputData(fromSURL, toSURL);
        return inputData;
    }

    public Map convertFromOutputData(OutputData data) {
        log.debug("SrmMv: Converter :Call received :Creation of XMLRPC Output Structure! ");
        HashMap outputParam = new HashMap();
        MvOutputData outputData = (MvOutputData)data;
        TReturnStatus status = outputData.getStatus();
        status.encode(outputParam, "returnStatus");
        return outputParam;
    }
}

