/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.directory;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.ArrayOfSURLs;
import it.grid.storm.srm.types.ArrayOfTMetaDataPathDetail;
import it.grid.storm.srm.types.InvalidArrayOfSURLsAttributeException;
import it.grid.storm.srm.types.TFileStorageType;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.directory.AnonymousLSInputData;
import it.grid.storm.synchcall.data.directory.IdentityLSInputData;
import it.grid.storm.synchcall.data.directory.LSOutputData;
import it.grid.storm.xmlrpc.converter.Converter;
import it.grid.storm.xmlrpc.converter.ParameterDisplayHelper;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LsConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(LsConverter.class);

    public InputData convertToInputData(Map inputParam) {
        log.debug("SrmLs: LSConverter :Call received :Creation of SpaceResData = " + inputParam.size());
        log.debug("SrmLs: LSConverter: Input Structure toString: " + ParameterDisplayHelper.display(inputParam));
        String member_fullDL = new String("fullDetailedList");
        String member_allLR = new String("allLevelRecursive");
        String member_numOL = new String("numOfLevels");
        String member_offset = new String("offset");
        String member_count = new String("count");
        GridUserInterface guser = GridUserManager.decode(inputParam);
        ArrayOfSURLs surlArray = null;
        try {
            surlArray = ArrayOfSURLs.decode(inputParam, "arrayOfSURLs");
        }
        catch (InvalidArrayOfSURLsAttributeException e2) {
            log.debug("SrmLs: Empty surlArray found!");
            surlArray = null;
        }
        TFileStorageType fileStorageType = TFileStorageType.decode(inputParam, "fileStorageType");
        log.debug("fileType: " + fileStorageType);
        Boolean fullDL = (Boolean)inputParam.get(member_fullDL);
        log.debug("fullDetailedList: " + fullDL);
        Boolean allLR = (Boolean)inputParam.get(member_allLR);
        log.debug("allLevelRecursive: " + allLR);
        Integer numOL = (Integer)inputParam.get(member_numOL);
        log.debug("numOfLevels: " + numOL);
        Integer offset = (Integer)inputParam.get(member_offset);
        log.debug("offset: " + offset);
        Integer count = (Integer)inputParam.get(member_count);
        log.debug("count: " + count);
        AnonymousLSInputData inputData = guser != null ? new IdentityLSInputData(guser, surlArray, fileStorageType, fullDL, allLR, numOL, offset, count) : new AnonymousLSInputData(surlArray, fileStorageType, fullDL, allLR, numOL, offset, count);
        return inputData;
    }

    public Hashtable convertFromOutputData(OutputData data) {
        ArrayOfTMetaDataPathDetail details;
        TRequestToken requestToken;
        Hashtable<String, String> outputParam = new Hashtable<String, String>();
        LSOutputData outputData = (LSOutputData)data;
        TReturnStatus globStatus = outputData.getStatus();
        if (globStatus != null) {
            globStatus.encode(outputParam, "returnStatus");
        }
        if ((requestToken = outputData.getRequestToken()) != null) {
            outputParam.put("requestToken", requestToken.toString());
        }
        if ((details = outputData.getDetails()) != null) {
            details.encode(outputParam, ArrayOfTMetaDataPathDetail.PNAME_DETAILS);
        }
        return outputParam;
    }
}

