/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.datatransfer;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.ArrayOfSURLs;
import it.grid.storm.srm.types.InvalidArrayOfSURLsAttributeException;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.datatransfer.AnonymousPutDoneInputData;
import it.grid.storm.synchcall.data.datatransfer.IdentityPutDoneInputData;
import it.grid.storm.xmlrpc.converter.Converter;
import it.grid.storm.xmlrpc.converter.datatransfer.ManageFileTransferConverter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutDoneConverter
extends ManageFileTransferConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(PutDoneConverter.class);

    @Override
    public InputData convertToInputData(Map<String, Object> inputParam) {
        ArrayOfSURLs arrayOfSURLs;
        TRequestToken requestToken;
        GridUserInterface guser = GridUserManager.decode(inputParam);
        try {
            requestToken = TRequestToken.decode(inputParam, "requestToken");
            log.debug("requestToken=" + requestToken.toString());
        }
        catch (InvalidTRequestTokenAttributesException e) {
            requestToken = null;
            log.debug("requestToken=NULL" + e);
        }
        try {
            arrayOfSURLs = ArrayOfSURLs.decode(inputParam, "arrayOfSURLs");
        }
        catch (InvalidArrayOfSURLsAttributeException e) {
            log.debug("Empty surlArray!");
            arrayOfSURLs = null;
        }
        AnonymousPutDoneInputData inputData = guser != null ? new IdentityPutDoneInputData(guser, requestToken, arrayOfSURLs) : new AnonymousPutDoneInputData(requestToken, arrayOfSURLs);
        log.debug("PutDoneInputData Created!");
        return inputData;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }
}

