/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.datatransfer;

import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TOverwriteMode;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.datatransfer.AnonymousPrepareToPutInputData;
import it.grid.storm.synchcall.data.datatransfer.IdentityPrepareToPutInputData;
import it.grid.storm.xmlrpc.StoRMXmlRpcException;
import it.grid.storm.xmlrpc.converter.datatransfer.FileTransferRequestInputConverter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareToPutRequestConverter
extends FileTransferRequestInputConverter {
    static final String OVERWRITE_MODE_PARAMETER_NAME = "overwriteMode";
    static final Logger log = LoggerFactory.getLogger(PrepareToPutRequestConverter.class);

    @Override
    public InputData convertToInputData(Map<String, Object> inputParam) throws IllegalArgumentException, StoRMXmlRpcException {
        String overwriteModeString;
        TSizeInBytes fileSize;
        TSpaceToken targetSpaceToken;
        TLifeTimeInSeconds desiredPinLifetime;
        AnonymousPrepareToPutInputData inputData;
        TSURL surl = this.decodeSURL(inputParam);
        GridUserInterface user = this.decodeUser(inputParam);
        TURLPrefix transferProtocols = this.decodeTransferProtocols(inputParam);
        try {
            inputData = user != null ? new IdentityPrepareToPutInputData(user, surl, transferProtocols) : new AnonymousPrepareToPutInputData(surl, transferProtocols);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to build PrepareToPutInputData. IllegalArgumentException: " + e.getMessage());
            throw new StoRMXmlRpcException("Unable to build PrepareToPutInputData");
        }
        TLifeTimeInSeconds desiredFileLifetime = TLifeTimeInSeconds.decode(inputParam, TLifeTimeInSeconds.PNAME_FILELIFETIME);
        if (desiredFileLifetime != null && !desiredFileLifetime.isEmpty()) {
            inputData.setDesiredFileLifetime(desiredFileLifetime);
        }
        if ((desiredPinLifetime = this.decodeDesiredPinLifetime(inputParam)) != null) {
            inputData.setDesiredPinLifetime(desiredPinLifetime);
        }
        if ((targetSpaceToken = this.decodeTargetSpaceToken(inputParam)) != null) {
            inputData.setTargetSpaceToken(targetSpaceToken);
        }
        if ((fileSize = TSizeInBytes.decode(inputParam, TSizeInBytes.PNAME_SIZE)) != null) {
            inputData.setFileSize(fileSize);
        }
        if ((overwriteModeString = (String)inputParam.get(OVERWRITE_MODE_PARAMETER_NAME)) != null) {
            TOverwriteMode overwriteMode;
            try {
                overwriteMode = TOverwriteMode.getTOverwriteMode(overwriteModeString);
            }
            catch (IllegalArgumentException e) {
                log.error("Unable to build TOverwriteMode from '" + overwriteModeString + "'. IllegalArgumentException: " + e.getMessage());
                throw new StoRMXmlRpcException("Unable to build PrepareToPutInputData");
            }
            if (!overwriteMode.equals(TOverwriteMode.EMPTY)) {
                inputData.setOverwriteMode(overwriteMode);
            } else {
                log.warn("Unable to use the received 'overwriteMode', interpreted as an empty value");
            }
        }
        log.debug("PrepareToPutInputData Created!");
        return inputData;
    }
}

