/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.datatransfer;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.ArrayOfSURLs;
import it.grid.storm.srm.types.InvalidArrayOfSURLsAttributeException;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.synchcall.data.AbstractInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.datatransfer.AnonymousManageFileTransferFilesInputData;
import it.grid.storm.synchcall.data.datatransfer.AnonymousManageFileTransferRequestFilesInputData;
import it.grid.storm.synchcall.data.datatransfer.AnonymousReleaseRequestInputData;
import it.grid.storm.synchcall.data.datatransfer.IdentityManageFileTransferFilesInputData;
import it.grid.storm.synchcall.data.datatransfer.IdentityManageFileTransferRequestFilesInputData;
import it.grid.storm.synchcall.data.datatransfer.IdentityReleaseRequestInputData;
import it.grid.storm.xmlrpc.converter.Converter;
import it.grid.storm.xmlrpc.converter.datatransfer.ManageFileTransferConverter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageFileTransferRequestConverter
extends ManageFileTransferConverter
implements Converter {
    static final Logger log = LoggerFactory.getLogger(ManageFileTransferRequestConverter.class);

    public InputData convertToInputData(Map inputParam) {
        ArrayOfSURLs arrayOfSURLs;
        GridUserInterface guser = GridUserManager.decode(inputParam);
        TRequestToken requestToken = null;
        try {
            requestToken = TRequestToken.decode(inputParam, "requestToken");
            log.debug("requestToken=" + requestToken.toString());
        }
        catch (InvalidTRequestTokenAttributesException e) {
            log.debug("No request token provided by user. InvalidTRequestTokenAttributesException: " + e.getMessage());
        }
        try {
            arrayOfSURLs = ArrayOfSURLs.decode(inputParam, "arrayOfSURLs");
        }
        catch (InvalidArrayOfSURLsAttributeException e) {
            log.debug("Empty surlArray!");
            arrayOfSURLs = null;
        }
        AbstractInputData inputData = guser != null ? (requestToken != null ? (arrayOfSURLs != null && arrayOfSURLs.size() > 0 ? new IdentityManageFileTransferRequestFilesInputData(guser, requestToken, arrayOfSURLs) : new IdentityReleaseRequestInputData(guser, requestToken)) : new IdentityManageFileTransferFilesInputData(guser, arrayOfSURLs)) : (requestToken != null ? (arrayOfSURLs != null && arrayOfSURLs.size() > 0 ? new AnonymousManageFileTransferRequestFilesInputData(requestToken, arrayOfSURLs) : new AnonymousReleaseRequestInputData(requestToken)) : new AnonymousManageFileTransferFilesInputData(arrayOfSURLs));
        return inputData;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }
}

