/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.datatransfer;

import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TTURL;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.datatransfer.AnonymousFileTransferInputData;
import it.grid.storm.synchcall.data.datatransfer.FileTransferOutputData;
import it.grid.storm.synchcall.data.datatransfer.IdentityFileTransferInputData;
import it.grid.storm.xmlrpc.StoRMXmlRpcException;
import it.grid.storm.xmlrpc.converter.Converter;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileTransferRequestInputConverter
implements Converter {
    static final Logger log = LoggerFactory.getLogger(FileTransferRequestInputConverter.class);

    @Override
    public InputData convertToInputData(Map<String, Object> inputParam) throws IllegalArgumentException, StoRMXmlRpcException {
        TSpaceToken targetSpaceToken;
        AnonymousFileTransferInputData inputData;
        TSURL surl = this.decodeSURL(inputParam);
        if (surl == null) {
            log.error("Missing mandatory parameter 'surl' Unable to build FileTransferInputData");
            throw new IllegalArgumentException("Missing mandatory parameter 'surl'");
        }
        GridUserInterface user = this.decodeUser(inputParam);
        TURLPrefix transferProtocols = this.decodeTransferProtocols(inputParam);
        if (transferProtocols == null) {
            log.error("Missing mandatory parameter 'turlPrefix' Unable to build FileTransferInputData");
            throw new IllegalArgumentException("Missing mandatory parameter 'turlPrefix'");
        }
        try {
            inputData = user != null ? new IdentityFileTransferInputData(user, surl, transferProtocols) : new AnonymousFileTransferInputData(surl, transferProtocols);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to build FileTransferInputData. IllegalArgumentException: " + e.getMessage());
            throw new StoRMXmlRpcException("Unable to build FileTransferInputData");
        }
        TLifeTimeInSeconds desiredPinLifetime = this.decodeDesiredPinLifetime(inputParam);
        if (desiredPinLifetime != null) {
            inputData.setDesiredPinLifetime(desiredPinLifetime);
        }
        if ((targetSpaceToken = this.decodeTargetSpaceToken(inputParam)) != null) {
            inputData.setTargetSpaceToken(targetSpaceToken);
        }
        return inputData;
    }

    @Override
    public Map<String, Object> convertFromOutputData(OutputData outputData) throws IllegalArgumentException {
        if (outputData == null) {
            log.error("Unable to build an output map. Null argument: outputData= " + outputData);
            throw new IllegalArgumentException("Unable to build a valid output map, null argument");
        }
        if (!(outputData instanceof FileTransferOutputData)) {
            log.error("Unable to convert from OutputData. Wrong OutputData type: '" + outputData.getClass().getName() + "'");
            throw new IllegalArgumentException("Unable to convert from OutputData. Wrong OutputData type: '" + outputData.getClass().getName() + "'");
        }
        FileTransferOutputData ftOutputData = (FileTransferOutputData)outputData;
        TSURL surl = ftOutputData.getSurl();
        TTURL turl = ftOutputData.getTurl();
        TReturnStatus status = ftOutputData.getStatus();
        TRequestToken requestToken = ftOutputData.getRequestToken();
        if (surl == null || surl.isEmpty() || surl.getSURLString().trim().isEmpty() || turl == null || status == null || requestToken == null || requestToken.getValue() == null || requestToken.getValue().isEmpty()) {
            log.error("Unable to build a valid output map. Missing mandatory values from FileTransferOutputData: " + ftOutputData.toString());
            throw new IllegalArgumentException("Unable to build a valid output map from FileTransferOutputData");
        }
        Hashtable<String, Object> outputParam = new Hashtable<String, Object>();
        surl.encode(outputParam, "surl");
        turl.encode(outputParam, "turl");
        status.encode(outputParam, "returnStatus");
        outputParam.put("requestToken", requestToken.toString());
        log.debug("Built output Map: " + outputParam.toString());
        return outputParam;
    }

    protected TSpaceToken decodeTargetSpaceToken(Map<String, Object> inputParam) {
        return TSpaceToken.decode(inputParam, TSpaceToken.PNAME_SPACETOKEN);
    }

    protected TLifeTimeInSeconds decodeDesiredPinLifetime(Map<String, Object> inputParam) {
        return TLifeTimeInSeconds.decode(inputParam, TLifeTimeInSeconds.PNAME_PINLIFETIME);
    }

    protected TURLPrefix decodeTransferProtocols(Map<String, Object> inputParam) throws IllegalArgumentException {
        TURLPrefix transferProtocols = TURLPrefix.decode(inputParam, "turlPrefix");
        if (transferProtocols == null) {
            log.error("Missing mandatory parameter 'turlPrefix' Unable to build FileTransferInputData");
            throw new IllegalArgumentException("Missing mandatory parameter 'turlPrefix'");
        }
        return transferProtocols;
    }

    protected GridUserInterface decodeUser(Map<String, Object> inputParam) {
        return GridUserManager.decode(inputParam);
    }

    protected TSURL decodeSURL(Map<String, Object> inputParam) throws IllegalArgumentException {
        TSURL surl = null;
        try {
            surl = TSURL.decode(inputParam, "surl");
        }
        catch (InvalidTSURLAttributesException e) {
            log.error("Unable to decode 'surl' parameter as TSURL. InvalidTSURLAttributesException: " + e.getMessage());
            throw new IllegalArgumentException("Unable to decode 'surl' parameter as TSURL");
        }
        return surl;
    }
}

