/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.datatransfer;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.ArrayOfSURLs;
import it.grid.storm.srm.types.ArrayOfTSURLLifetimeReturnStatus;
import it.grid.storm.srm.types.InvalidArrayOfSURLsAttributeException;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.datatransfer.AnonymousExtendFileLifeTimeInputData;
import it.grid.storm.synchcall.data.datatransfer.ExtendFileLifeTimeOutputData;
import it.grid.storm.synchcall.data.datatransfer.IdentityExtendFileLifeTimeInputData;
import it.grid.storm.xmlrpc.converter.Converter;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendFileLifeTimeConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(ExtendFileLifeTimeConverter.class);

    public InputData convertToInputData(Map inputParam) {
        ArrayOfSURLs arrayOfSURLs;
        TRequestToken requestToken;
        GridUserInterface guser = GridUserManager.decode(inputParam);
        String authID = (String)inputParam.get("authorizationID");
        try {
            requestToken = TRequestToken.decode(inputParam, "requestToken");
            log.debug("requestToken=" + requestToken.toString());
        }
        catch (InvalidTRequestTokenAttributesException e) {
            requestToken = null;
            log.error("requestToken=NULL");
        }
        try {
            arrayOfSURLs = ArrayOfSURLs.decode(inputParam, "arrayOfSURLs");
        }
        catch (InvalidArrayOfSURLsAttributeException e) {
            log.error("Empty surlArray!");
            arrayOfSURLs = null;
        }
        TLifeTimeInSeconds newFileLifetime = TLifeTimeInSeconds.decode(inputParam, TLifeTimeInSeconds.PNAME_FILELIFETIME);
        TLifeTimeInSeconds newPinLifetime = TLifeTimeInSeconds.decode(inputParam, TLifeTimeInSeconds.PNAME_PINLIFETIME);
        AnonymousExtendFileLifeTimeInputData inputData = guser != null ? new IdentityExtendFileLifeTimeInputData(guser, requestToken, arrayOfSURLs, newFileLifetime, newPinLifetime) : new AnonymousExtendFileLifeTimeInputData(requestToken, arrayOfSURLs, newFileLifetime, newPinLifetime);
        return inputData;
    }

    public Hashtable convertFromOutputData(OutputData data) {
        ArrayOfTSURLLifetimeReturnStatus arrayOfFileStatuses;
        log.debug("ExtendFileLifeTimeOutputData - Creation of XMLRPC Output Structure!");
        Hashtable outputParam = new Hashtable();
        ExtendFileLifeTimeOutputData outputData = (ExtendFileLifeTimeOutputData)data;
        TReturnStatus returnStatus = outputData.getReturnStatus();
        if (returnStatus != null) {
            returnStatus.encode(outputParam, "returnStatus");
        }
        if ((arrayOfFileStatuses = outputData.getArrayOfFileStatuses()) != null) {
            arrayOfFileStatuses.encode(outputParam, ArrayOfTSURLLifetimeReturnStatus.PNAME_ARRAYOFFILESTATUSES);
        }
        log.debug("ExtendFileLifeTimeConverter - Sending: " + outputParam.toString());
        return outputParam;
    }
}

