/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.datatransfer;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.datatransfer.AbortGeneralOutputData;
import it.grid.storm.synchcall.data.datatransfer.AbortRequestOutputData;
import it.grid.storm.synchcall.data.datatransfer.AnonymousAbortRequestInputData;
import it.grid.storm.synchcall.data.datatransfer.IdentityAbortRequestInputData;
import it.grid.storm.xmlrpc.converter.Converter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbortRequestConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(AbortRequestConverter.class);

    public InputData convertToInputData(Map inputParam) {
        TRequestToken requestToken;
        GridUserInterface guser = GridUserManager.decode(inputParam);
        try {
            requestToken = TRequestToken.decode(inputParam, "requestToken");
            log.debug("requestToken=" + requestToken.toString());
        }
        catch (InvalidTRequestTokenAttributesException e) {
            requestToken = null;
            log.debug("requestToken=NULL");
        }
        AnonymousAbortRequestInputData inputData = guser != null ? new IdentityAbortRequestInputData(guser, requestToken) : new AnonymousAbortRequestInputData(requestToken);
        return inputData;
    }

    public Map convertFromOutputData(OutputData data) {
        log.debug("AbortRequestOutputData - Creation of XMLRPC Output Structure!");
        HashMap outputParam = new HashMap();
        AbortRequestOutputData outputData = AbortRequestOutputData.make((AbortGeneralOutputData)data);
        TReturnStatus returnStatus = outputData.getReturnStatus();
        if (returnStatus != null) {
            returnStatus.encode(outputParam, "returnStatus");
        }
        log.debug("AbortRequestConverter - Sending: " + ((Object)outputParam).toString());
        return outputParam;
    }
}

