/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.wrapper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;

public class Passwd {
    private Map nameMap = new Hashtable();
    private Map uidMap = new Hashtable();
    private PasswdRefresher refresher;
    private File passwdFile;

    public Passwd(String path, boolean refresh) {
        this.passwdFile = new File(path);
        if (refresh) {
            this.refresher = new PasswdRefresher(this);
        }
    }

    public Passwd() {
        this("/etc/passwd", false);
    }

    public void digestPasswd() {
        this.emptyMap();
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(this.passwdFile));
            while ((str = in.readLine()) != null) {
                PasswdRow row = this.digestPasswdRow(str);
                if (row == null) continue;
                this.insertRow(row);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void emptyMap() {
        this.nameMap.clear();
        this.uidMap.clear();
    }

    private void insertRow(PasswdRow row) {
        this.nameMap.put(row.getName(), row);
        this.uidMap.put(new Integer(row.getUID()), row);
    }

    private PasswdRow digestPasswdRow(String line) {
        PasswdRow passwdRow = null;
        if (line != null) {
            StringTokenizer tok = new StringTokenizer(line, ":");
            String[] row = new String[7];
            for (int i = 0; i < row.length && tok.hasMoreTokens(); ++i) {
                row[i] = tok.nextToken();
            }
            passwdRow = new PasswdRow(row);
        }
        return passwdRow;
    }

    public boolean existsByName(String name) {
        return this.nameMap.containsKey(name);
    }

    public boolean existsByUID(int uid) {
        return this.uidMap.containsKey(new Integer(uid));
    }

    protected File getPasswdFile() {
        return this.passwdFile;
    }

    protected PasswdRow getEntryByName(String name) {
        return (PasswdRow)this.nameMap.get(name);
    }

    protected PasswdRow getEntryByUID(int uid) {
        return (PasswdRow)this.uidMap.get(new Integer(uid));
    }

    public String getNameByUID(int uid) {
        return this.getEntryByUID(uid).getName();
    }

    public int getUIDbyName(String name) {
        int result = -1;
        PasswdRow row = this.getEntryByName(name);
        if (row != null) {
            result = row.getUID();
        }
        return result;
    }

    public int getRowNumber() {
        return this.nameMap.size();
    }

    private static class PasswdRow {
        public String name;
        public String passwd;
        public int uid;
        public int gid;
        public String gecos;
        public String homedir;
        public String shell;

        public PasswdRow(String[] item) {
            this.name = item[0];
            this.passwd = item[1];
            this.uid = PasswdRow.parseNum(item[2]);
            this.gid = PasswdRow.parseNum(item[3]);
            this.gecos = item[4];
            this.homedir = item[5];
            this.shell = item[6];
        }

        private static int parseNum(String s) {
            if (s == null) {
                return -1;
            }
            try {
                return Integer.parseInt(s.trim());
            }
            catch (NumberFormatException n) {
                return -1;
            }
        }

        public String getName() {
            return this.name;
        }

        public int getUID() {
            return this.uid;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("Name : ");
            result.append(this.name);
            result.append(" UID : ");
            result.append(this.gid);
            result.append(" GID : ");
            result.append(this.uid);
            return result.toString();
        }
    }

    private static class PasswdRefresher {
        int delay = 5000;
        int period = 1000;
        Timer timer = new Timer();
        Passwd passwd;
        private long modifiedTime = -1L;

        public PasswdRefresher(Passwd passwd, int period) {
            this.period = period;
            this.passwd = passwd;
            this.schedule();
        }

        public PasswdRefresher(Passwd passwd) {
            this.passwd = passwd;
            this.modifiedTime = passwd.getPasswdFile().lastModified();
            this.schedule();
        }

        private void schedule() {
            this.timer.scheduleAtFixedRate(new TimerTask(){
                long newTime = -1L;

                @Override
                public void run() {
                    this.newTime = PasswdRefresher.this.passwd.getPasswdFile().lastModified();
                    if (this.newTime > PasswdRefresher.this.modifiedTime) {
                        System.out.println("####");
                        PasswdRefresher.this.modifiedTime = this.newTime;
                        PasswdRefresher.this.passwd.digestPasswd();
                    }
                }
            }, this.delay, (long)this.period);
        }
    }
}

