/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.tape.recalltable.resources;

import it.grid.storm.config.Configuration;
import it.grid.storm.persistence.model.TapeRecallTO;
import it.grid.storm.tape.recalltable.TapeRecallCatalog;
import it.grid.storm.tape.recalltable.TapeRecallException;
import it.grid.storm.tape.recalltable.model.TapeRecallStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/recalltable/tasks")
public class TasksResource {
    private static final Logger log = LoggerFactory.getLogger(TasksResource.class);
    private static Configuration config = Configuration.getInstance();

    @PUT
    @Path(value="/")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String putTakeoverTasks(InputStream input) throws TapeRecallException {
        String inputStr = this.buildInputString(input);
        log.debug("@PUT (input string) = '" + inputStr + "'");
        int numbOfTask = 1;
        String keyTakeover = config.getTaskoverKey();
        int eqIndex = inputStr.indexOf(61);
        if (eqIndex > 0) {
            String value = inputStr.substring(eqIndex);
            String key = inputStr.substring(0, eqIndex);
            if (key.equals(keyTakeover)) {
                try {
                    numbOfTask = Integer.valueOf(value.substring(1, value.length() - 1));
                }
                catch (NumberFormatException e) {
                    throw new TapeRecallException("Unable to understand the number value = '" + value + "'");
                }
            }
        }
        ArrayList<TapeRecallTO> tasks = new TapeRecallCatalog().takeoverNTasksWithDoubles(numbOfTask);
        HashMap<UUID, ArrayList<TapeRecallTO>> groupTaskMap = this.buildGroupTaskMap(tasks);
        ArrayList<TapeRecallTO> groupTasks = new ArrayList<TapeRecallTO>();
        for (ArrayList<TapeRecallTO> groupTaskList : groupTaskMap.values()) {
            try {
                groupTasks.add(this.makeOne(groupTaskList));
            }
            catch (IllegalArgumentException e) {
                log.error("Unable to makeOne the task list . IllegalArgumentException : " + e.getMessage());
                log.error("Erroneous task list (long output): " + groupTaskList.toString());
                log.error("Skip the erroneous task list and go on...Please contact StoRM support");
            }
        }
        if (tasks.size() > groupTasks.size()) {
            log.debug("Taking over some multy-group tasks");
        }
        log.debug("Number of tasks recalled : <" + groupTasks.size() + "> over <" + tasks.size() + "> tasks requested");
        String result = this.buildTakeoverTasksResponse(groupTasks);
        return result;
    }

    private HashMap<UUID, ArrayList<TapeRecallTO>> buildGroupTaskMap(ArrayList<TapeRecallTO> tasks) {
        HashMap<UUID, ArrayList<TapeRecallTO>> groupTaskMap = new HashMap<UUID, ArrayList<TapeRecallTO>>();
        for (TapeRecallTO task : tasks) {
            ArrayList<TapeRecallTO> taskList = groupTaskMap.get(task.getGroupTaskId());
            if (taskList == null) {
                taskList = new ArrayList();
                groupTaskMap.put(task.getGroupTaskId(), taskList);
            }
            taskList.add(task);
        }
        return groupTaskMap;
    }

    private TapeRecallTO makeOne(ArrayList<TapeRecallTO> recallTasks) throws IllegalArgumentException {
        TapeRecallTO taskTO = new TapeRecallTO();
        UUID taskId = recallTasks.get(0).getTaskId();
        for (TapeRecallTO recallTask : recallTasks) {
            if (recallTask.getTaskId().equals(taskId)) continue;
            log.error("Received a list of not omogeneous tasks, the taskid '" + taskId + "' is not matched by : " + recallTask.toString());
            throw new IllegalArgumentException("Received a list of not omogeneous tasks");
        }
        Iterator<TapeRecallTO> i$ = recallTasks.iterator();
        if (i$.hasNext()) {
            TapeRecallTO recallTask;
            recallTask = i$.next();
            taskTO.setTaskId(recallTask.getTaskId());
            taskTO.setGroupTaskId(recallTask.getGroupTaskId());
            taskTO.setRequestToken(recallTask.getRequestToken());
            taskTO.setRequestType(recallTask.getRequestType());
            taskTO.setFileName(recallTask.getFileName());
            taskTO.setUserID(recallTask.getUserID());
            taskTO.setVoName(recallTask.getVoName());
            taskTO.setStatus(TapeRecallStatus.QUEUED);
        }
        int maxRetryAttempt = 0;
        Date minInsertionInstant = null;
        Date minDeferredRecallInstant = null;
        Date maxPinExpirationInstant = null;
        for (TapeRecallTO recallTask : recallTasks) {
            if (recallTask.getRetryAttempt() > maxRetryAttempt) {
                maxRetryAttempt = recallTask.getRetryAttempt();
            }
            if (minInsertionInstant == null || recallTask.getInsertionInstant().before(minInsertionInstant)) {
                minInsertionInstant = recallTask.getInsertionInstant();
            }
            if (minDeferredRecallInstant == null || recallTask.getDeferredRecallInstant().before(minDeferredRecallInstant)) {
                minDeferredRecallInstant = recallTask.getDeferredRecallInstant();
            }
            Date currentPinExpirationInstant = new Date(recallTask.getDeferredRecallInstant().getTime() + (long)(recallTask.getPinLifetime() * 1000));
            if (maxPinExpirationInstant != null && !currentPinExpirationInstant.after(maxPinExpirationInstant)) continue;
            maxPinExpirationInstant = currentPinExpirationInstant;
        }
        taskTO.setRetryAttempt(maxRetryAttempt);
        taskTO.setInsertionInstant(minInsertionInstant);
        taskTO.setDeferredRecallInstant(minDeferredRecallInstant);
        int pinLifeTime = (int)(maxPinExpirationInstant.getTime() - minDeferredRecallInstant.getTime()) / 1000;
        taskTO.setPinLifetime(pinLifeTime);
        return taskTO;
    }

    private String buildTakeoverTasksResponse(ArrayList<TapeRecallTO> tasks) {
        String result = "{";
        for (TapeRecallTO recallTaskTO : tasks) {
            result = result + recallTaskTO.toGEMSS() + " # ";
        }
        result = result + "}";
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildInputString(InputStream input) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String inputStr = sb.toString();
        return inputStr;
    }
}

