/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.tape.recalltable.resources;

import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.tape.recalltable.TapeRecallCatalog;
import it.grid.storm.tape.recalltable.TapeRecallException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/recalltable/cardinality/tasks/")
public class TasksCardinality {
    private static final Logger log = LoggerFactory.getLogger(TasksCardinality.class);

    @GET
    @Path(value="/queued")
    @Produces(value={"text/plain"})
    public String getNumberQueued() throws TapeRecallException {
        String numberQueued = "";
        int nQueued = -1;
        String errorStr = null;
        TapeRecallCatalog rtCat = null;
        try {
            rtCat = new TapeRecallCatalog();
            nQueued = rtCat.getNumberTaskQueued();
            if (nQueued > 0) {
                log.info("Number of tasks queued = " + nQueued);
            } else {
                log.trace("Number of tasks queued = " + nQueued);
            }
            numberQueued = numberQueued + nQueued;
        }
        catch (DataAccessException e) {
            errorStr = "Unable to use RecallTable DB.";
            log.error(errorStr);
            throw new TapeRecallException(errorStr);
        }
        return numberQueued;
    }

    @GET
    @Path(value="/readyTakeOver")
    @Produces(value={"text/plain"})
    public String getReadyForTakeover() throws TapeRecallException {
        String numberReadyForTakeover = "";
        int nReadyForTakeover = -1;
        String errorStr = null;
        TapeRecallCatalog rtCat = null;
        try {
            rtCat = new TapeRecallCatalog();
            nReadyForTakeover = rtCat.getReadyForTakeOver();
            log.debug("Number of tasks queued = " + nReadyForTakeover);
            numberReadyForTakeover = numberReadyForTakeover + nReadyForTakeover;
        }
        catch (DataAccessException e) {
            errorStr = "Unable to use RecallTable DB.";
            log.error(errorStr);
            throw new TapeRecallException(errorStr);
        }
        return numberReadyForTakeover;
    }
}

