/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.tape.recalltable.persistence;

import it.grid.storm.persistence.model.TapeRecallTO;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.tape.recalltable.model.TapeRecallData;
import it.grid.storm.tape.recalltable.model.TapeRecallStatus;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapeRecallBuilder {
    private static final Logger log = LoggerFactory.getLogger(TapeRecallBuilder.class);
    public static final String taskStart = "{";
    public static final String taskEnd = "}";
    public static final String elementSep = " # ";
    public static final String fnPrefix = "filename";
    public static final String dnPrefix = "dn";
    public static final String fqansPrefix = "fqans";
    public static final String fqansArrayStart = "[";
    public static final String fqansArrayEnd = "]";
    public static final String fqanPrefix = "fqan";
    public static final String fqanSep = ",";
    public static final String voNamePrefix = "vo-name";
    public static final String userIdPrefix = "userId";
    public static final String equalChar = "=";

    public static TapeRecallTO buildFromPOST(TapeRecallData rtd) {
        TRequestToken localRT;
        TapeRecallTO task = new TapeRecallTO();
        Date currentDate = new Date();
        task.setInsertionInstant(currentDate);
        task.setRequestType("back");
        String localRequestToken = "local-" + UUID.randomUUID();
        try {
            localRT = new TRequestToken(localRequestToken, Calendar.getInstance().getTime());
        }
        catch (InvalidTRequestTokenAttributesException e) {
            throw new IllegalStateException("Unexpected InvalidTRequestTokenAttributesException: " + e);
        }
        task.setRequestToken(localRT);
        task.setPinLifetime(-1);
        task.setDeferredRecallInstant(currentDate);
        task.setUserID(rtd.getUserID());
        task.setVoName(rtd.getVoName());
        task.setFileName(rtd.getFileName());
        return task;
    }

    private static TapeRecallStatus parseTaskStatus(String taskStatus) {
        TapeRecallStatus result = TapeRecallStatus.UNDEFINED;
        try {
            result = TapeRecallStatus.getRecallTaskStatus(taskStatus);
        }
        catch (Exception e) {
            log.error("Task Status '" + taskStatus + "' is not in a valid format.");
            e.printStackTrace();
        }
        return result;
    }

    private static int parseInt(String number) {
        int result = 0;
        try {
            result = Integer.parseInt(number);
        }
        catch (Exception e) {
            log.error("Number'" + number + "' is not in a valid format.");
            e.printStackTrace();
        }
        return result;
    }

    private static Date parseDate(String dateString) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH.mm.ss");
        Date date = new Date();
        try {
            date = formatter.parse(dateString);
        }
        catch (ParseException e) {
            log.error("Date '" + dateString + "' is not in a valid format.");
            e.printStackTrace();
        }
        return date;
    }
}

