/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.tape.recalltable.persistence;

import it.grid.storm.config.Configuration;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TapeRecallTO;
import it.grid.storm.srm.types.TRequestToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesDB {
    private static final Logger log = LoggerFactory.getLogger(PropertiesDB.class);
    private static Configuration config = Configuration.getInstance();
    private final String dataFileName = "recall-table.txt";
    private final String propertiesDBName;

    public PropertiesDB() {
        String configurationDir = config.configurationDir();
        char sep = File.separatorChar;
        this.propertiesDBName = configurationDir + sep + "etc" + sep + "db" + sep + "recall-table.txt";
        log.debug("Properties RecallTable-DB = " + this.propertiesDBName);
    }

    public PropertiesDB(boolean test) {
        String configurationDir = test ? System.getProperty("user.dir") : config.configurationDir();
        char sep = File.separatorChar;
        this.propertiesDBName = configurationDir + sep + "etc" + sep + "db" + sep + "recall-table.txt";
        File tasksDBfile = new File(this.propertiesDBName);
        boolean success = false;
        try {
            success = tasksDBfile.createNewFile();
        }
        catch (IOException e) {
            log.error("Error while trying to check : " + this.propertiesDBName);
            e.printStackTrace();
        }
        if (success) {
            log.debug("TaskDB = '" + this.propertiesDBName + "' exists ? " + success);
        }
    }

    public void addRecallTask(TapeRecallTO task) throws FileNotFoundException, IOException, DataAccessException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(this.propertiesDBName));
        TRequestToken taskToken = task.getRequestToken();
        if (taskToken == null) {
            log.error("You are trying to store a Task without a task-id.");
            throw new DataAccessException("You are trying to store a Task without a task-id.");
        }
        String taskStr = task.toString();
        properties.setProperty(taskToken.getValue(), taskStr);
        properties.store(new FileOutputStream(this.propertiesDBName), null);
    }

    public void setRecallTask(List<TapeRecallTO> listTasks) throws FileNotFoundException, IOException, DataAccessException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(this.propertiesDBName));
        TRequestToken taskToken = null;
        String taskStr = null;
        for (TapeRecallTO TapeRecallTO2 : listTasks) {
            taskToken = TapeRecallTO2.getRequestToken();
            if (taskToken == null) {
                log.error("You are trying to store a Task without a RequestToken.");
                throw new DataAccessException("You are trying to store a Task without a Request-Token.");
            }
            taskStr = TapeRecallTO2.toString();
            properties.setProperty(taskToken.getValue(), taskStr);
            taskToken = null;
        }
        properties.store(new FileOutputStream(this.propertiesDBName), null);
    }

    public void updateRecallTask(TapeRecallTO task) throws FileNotFoundException, IOException, DataAccessException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(this.propertiesDBName));
        UUID taskId = task.getTaskId();
        boolean taskExist = properties.containsKey(taskId.toString());
        if (!taskExist) {
            log.error("Unable to find the task with ID = " + taskId);
            throw new DataAccessException("Unable to find the task with ID = " + taskId);
        }
        String taskStr = task.toString();
        properties.setProperty(taskId.toString(), taskStr);
        log.debug("Removed tasks '" + taskId + "'");
        properties.store(new FileOutputStream(this.propertiesDBName), null);
    }

    public void deleteRecallTask(UUID taskId) throws FileNotFoundException, IOException, DataAccessException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(this.propertiesDBName));
        String task = properties.getProperty(taskId.toString());
        if (task == null) {
            log.error("Unable to find the task with ID = " + taskId);
            throw new DataAccessException("Unable to find the task with ID = " + taskId);
        }
        properties.remove(taskId);
        log.debug("Removed tasks '" + taskId + "'");
        properties.store(new FileOutputStream(this.propertiesDBName), null);
    }
}

