/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.tape.recalltable.model;

public enum TapeRecallStatus {
    SUCCESS(0, "success"),
    QUEUED(1, "queued"),
    IN_PROGRESS(2, "in-progress"),
    ERROR(3, "error"),
    ABORTED(4, "aborted"),
    UNDEFINED(5, "undefined");

    private final int taskStatusRepresentation;
    private final String statusName;

    private TapeRecallStatus(int statusId, String statusName) {
        this.taskStatusRepresentation = statusId;
        this.statusName = statusName;
    }

    public static TapeRecallStatus getRecallTaskStatus(int statusId) {
        switch (statusId) {
            case 0: {
                return SUCCESS;
            }
            case 1: {
                return QUEUED;
            }
            case 2: {
                return IN_PROGRESS;
            }
            case 3: {
                return ERROR;
            }
            case 4: {
                return ABORTED;
            }
        }
        return UNDEFINED;
    }

    public static TapeRecallStatus getRecallTaskStatus(String status) {
        if (status.toLowerCase().equals(ABORTED.toString().toLowerCase())) {
            return ABORTED;
        }
        if (status.toLowerCase().equals(SUCCESS.toString().toLowerCase())) {
            return SUCCESS;
        }
        if (status.toLowerCase().equals(IN_PROGRESS.toString().toLowerCase())) {
            return IN_PROGRESS;
        }
        if (status.toLowerCase().equals(ERROR.toString().toLowerCase())) {
            return ERROR;
        }
        if (status.toLowerCase().equals(QUEUED.toString().toLowerCase())) {
            return QUEUED;
        }
        return UNDEFINED;
    }

    private boolean isFinalStatus() {
        return TapeRecallStatus.isFinalStatus(this.getStatusId());
    }

    public static boolean isFinalStatus(int statusId) {
        switch (statusId) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    public int getStatusId() {
        return this.taskStatusRepresentation;
    }

    public boolean precedes(int otherStatusId) {
        return this.precedes(TapeRecallStatus.getRecallTaskStatus(otherStatusId));
    }

    public boolean precedes(TapeRecallStatus otherStatus) {
        if (this.equals((Object)UNDEFINED) || otherStatus.equals((Object)UNDEFINED)) {
            return false;
        }
        if (this.equals((Object)otherStatus)) {
            return false;
        }
        boolean response = false;
        if (this.equals((Object)QUEUED)) {
            response = true;
        } else if (this.equals((Object)IN_PROGRESS) && otherStatus.isFinalStatus()) {
            response = true;
        }
        return response;
    }

    public String toString() {
        return this.statusName;
    }
}

