/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.tape.recalltable.model;

import it.grid.storm.griduser.AbstractGridUser;
import it.grid.storm.griduser.DistinguishedName;
import it.grid.storm.griduser.FQAN;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.tape.recalltable.TapeRecallException;
import it.grid.storm.tape.recalltable.persistence.TapeRecallBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapeRecallData {
    public static String ANONYMOUS_USER = "anonymous";
    private static final Logger log = LoggerFactory.getLogger(TapeRecallBuilder.class);
    public static String UNSPECIFIED_FN = "filename N/A";
    public static String UNSPECIFIED_VO = "unspecified-VO";
    private String fileName = null;
    private String userId = null;
    private String voName = null;
    private String userDN = null;
    private String[] fqansString = null;
    private ArrayList<FQAN> fqans = null;

    public static TapeRecallData buildFromString(String inputString) throws TapeRecallException {
        TapeRecallData result = new TapeRecallData();
        int beginArray = inputString.indexOf("{");
        int endArray = inputString.indexOf("}");
        if (beginArray >= 0 && endArray > 0 && beginArray < endArray) {
            String parameters = inputString.substring(beginArray + 1, endArray);
            String[] paramArray = parameters.split(" # ");
            for (int i = 0; i < paramArray.length; ++i) {
                log.debug("param[" + i + "]=" + paramArray[i]);
                if (!paramArray[i].contains("=")) continue;
                int equalIndex = paramArray[i].indexOf("=");
                String key = paramArray[i].substring(0, equalIndex);
                String value = paramArray[i].substring(equalIndex + 1, paramArray[i].length());
                log.debug("KEY:" + key + " VALUE:" + value);
                if (key.equals("filename")) {
                    result.fileName = value;
                    continue;
                }
                if (key.equals("userId")) {
                    result.userId = value;
                    continue;
                }
                if (key.equals("vo-name")) {
                    result.voName = value;
                    continue;
                }
                if (key.equals("fqans")) {
                    result.fqans = result.parseFQANs(value, 0, 0, 0, value.length());
                    continue;
                }
                log.warn("Unknown key-value pair (" + key + "," + value + "). StoRM will ignore them.");
            }
        } else {
            throw new TapeRecallException("Unable to understand :'" + inputString + "'");
        }
        return result;
    }

    public TapeRecallData() {
        this.fileName = UNSPECIFIED_FN;
        this.userId = ANONYMOUS_USER;
        this.voName = UNSPECIFIED_VO;
    }

    public TapeRecallData(String textFormat) throws TapeRecallException {
        if (textFormat.startsWith("{")) {
            if (textFormat.contains("}")) {
                int voNamePos;
                int fqansPos;
                int beginIndex = 1;
                int endIndex = textFormat.indexOf("}");
                String taskDataText = textFormat.substring(beginIndex, endIndex);
                int fnPos = taskDataText.indexOf("filename");
                if (fnPos < 0) {
                    throw new TapeRecallException("Unable to find the File Name");
                }
                int dnPos = taskDataText.indexOf("dn");
                if (dnPos < 0) {
                    log.warn("Task Data without User DN");
                }
                if ((fqansPos = taskDataText.indexOf("fqans")) < 1) {
                    log.warn("Task Data without User FQANs");
                }
                if ((voNamePos = taskDataText.indexOf("vo-name")) < 1) {
                    log.warn("Task Data without VO Name");
                }
                this.fileName = this.parseFN(taskDataText, fnPos, dnPos, fqansPos, voNamePos);
                this.userDN = this.parseDN(taskDataText, fnPos, dnPos, fqansPos, voNamePos);
                this.fqans = this.parseFQANs(taskDataText, fnPos, dnPos, fqansPos, voNamePos);
                this.voName = this.parseVOName(taskDataText, fnPos, dnPos, fqansPos, voNamePos);
                log.debug("filename='" + this.fileName + "'");
                log.debug("userDN  ='" + this.userDN + "'");
                log.debug("fqans='" + this.fqans + "'");
                log.debug("voName='" + this.voName + "'");
            } else {
                throw new TapeRecallException("Unable to find the File Name");
            }
        }
    }

    public TapeRecallData(String filename, GridUserInterface user) {
        this.fileName = filename;
        if (user instanceof AbstractGridUser && ((AbstractGridUser)user).hasVoms()) {
            AbstractGridUser gridUser = (AbstractGridUser)user;
            this.fqans = new ArrayList<FQAN>(Arrays.asList(gridUser.getFQANs()));
            this.fqansString = gridUser.getFQANsAsString();
            this.voName = gridUser.getVO().getValue();
        } else {
            this.voName = UNSPECIFIED_VO;
        }
        this.userDN = user.getDistinguishedName().getDN();
    }

    public TapeRecallData(String filename, String dn, String[] fqans, String voName) {
        this.fileName = filename;
        DistinguishedName dn500 = new DistinguishedName(dn);
        this.userDN = dn500.getX500DN_rfc2253();
        this.fqansString = fqans;
        this.voName = voName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getUserID() {
        if (this.userId.equals(ANONYMOUS_USER) && this.getUserDN() != null) {
            this.userId = this.getUserDN();
            if (this.getFqansTextFormat() != null) {
                this.userId = this.userId + " - " + this.getFqansTextFormat();
            }
        }
        return this.userId;
    }

    public String getVoName() {
        return this.voName;
    }

    public String getRecallTaskData_textFormat() {
        String result = "";
        result = result + "{";
        result = result + this.getFileNameTextFormat() + " # ";
        result = result + this.getUserDNTextFormat() + " # ";
        result = result + this.getFqansTextFormat() + " # ";
        result = result + this.getVONameTextFormat();
        result = result + "}";
        return result;
    }

    private String getUserDN() {
        return this.userDN;
    }

    private String getVONameTextFormat() {
        String result = "";
        result = result + "vo-name";
        result = result + this.getVoName();
        return result;
    }

    private String parseDN(String taskDataText, int fnPos, int dnPos, int fqansPos, int voNamePos) {
        String result = null;
        if (dnPos > 0) {
            if (fqansPos > 0) {
                result = taskDataText.substring(dnPos, fqansPos - 1);
                log.debug("dn to parse (dnPos=" + dnPos + " fqansPos=" + fqansPos + ": " + result);
            } else {
                result = voNamePos > 0 ? taskDataText.substring(dnPos, voNamePos - 1) : taskDataText.substring(dnPos);
            }
        } else {
            result = "no-DN";
        }
        int pos = result.indexOf(" # ");
        pos = pos < 0 ? result.length() : pos;
        result = result.substring("dn".length(), pos);
        log.debug("DN to parse ='" + result + "'");
        log.warn("## TODO Feature ## : Bug in parsing DN in RFC 2253 format.");
        if (result.contains("CN=")) {
            int beginIndex = result.indexOf("CN=") + 3;
            int endIndex = (result = result.substring(beginIndex)).contains(",") ? result.indexOf(44) : result.length();
            result = result.substring(0, endIndex);
            endIndex = result.contains("/") ? result.indexOf(47) : result.length();
            result = result.substring(0, endIndex);
        }
        log.debug("DN parsed ='" + result + "'");
        return result;
    }

    private String parseFN(String taskDataText, int fnPos, int dnPos, int fqansPos, int voNamePos) {
        String result = null;
        result = dnPos > 0 ? taskDataText.substring(fnPos, dnPos) : (fqansPos > 0 ? taskDataText.substring(fnPos, fqansPos) : (voNamePos > 0 ? taskDataText.substring(fnPos, voNamePos) : taskDataText.substring(fnPos)));
        log.debug("FN to parse ='" + result + "'");
        int pos = result.indexOf(" # ");
        pos = pos < 0 ? result.length() : pos;
        result = result.substring("filename".length(), pos);
        log.debug("FN parsed ='" + result + "'");
        return result;
    }

    private ArrayList<FQAN> parseFQANs(String taskDataText, int fnPos, int dnPos, int fqansPos, int voNamePos) {
        ArrayList<FQAN> result = new ArrayList<FQAN>();
        String fqansSt = null;
        if (fqansPos > 0) {
            fqansSt = voNamePos > 0 ? taskDataText.substring(fqansPos, voNamePos) : taskDataText.substring(fqansPos);
            int pos = fqansSt.indexOf(" # ");
            pos = pos < 0 ? fqansSt.length() : pos;
            fqansSt = fqansSt.substring("fqans".length(), pos);
            log.debug(fqansSt);
            pos = fqansSt.indexOf("]");
            fqansSt = fqansSt.substring("[".length(), pos);
            log.debug(fqansSt);
            String[] fqans = fqansSt.split(",");
            this.fqansString = new String[fqans.length];
            int count = 0;
            for (String fqanIter : fqans) {
                log.debug("fqanString = '" + fqanIter + "'");
                pos = fqansSt.indexOf(",");
                pos = pos < 0 ? fqansSt.length() : pos;
                fqanIter = fqanIter.substring("fqan".length(), pos);
                log.debug("fqanString (purged) = '" + fqanIter + "'");
                FQAN fqan = new FQAN(fqanIter);
                result.add(fqan);
                this.fqansString[count] = fqan.toString();
                ++count;
            }
        } else {
            log.debug("no FQANs are present into RecallTask Data.");
        }
        return result;
    }

    private String parseVOName(String taskDataText, int fnPos, int dnPos, int fqansPos, int voNamePos) {
        String result = null;
        if (voNamePos > 0) {
            result = taskDataText.substring(voNamePos);
            log.debug("vo-name to parse ='" + result + "'");
            int pos = result.indexOf(" # ");
            pos = pos < 0 ? result.length() : pos;
            result = result.substring("vo-name".length(), pos);
        } else if (this.fqans != null) {
            FQAN fqan = this.fqans.get(0);
            result = fqan.getVo();
        } else {
            result = "no-voname";
        }
        log.debug("vo-name parsed ='" + result + "'");
        return result;
    }

    private String getFileNameTextFormat() {
        String result = "";
        result = result + "filename";
        result = result + this.getFileName();
        return result;
    }

    private String[] getFqans() {
        if (this.fqans != null && this.fqans.size() > 0) {
            this.fqansString = new String[this.fqans.size()];
            int count = 0;
            for (FQAN fqan : this.fqans) {
                this.fqansString[count] = fqan.toString();
                ++count;
            }
        }
        return this.fqansString;
    }

    private String getFqansTextFormat() {
        String result = "";
        int fqansNum = this.fqansString != null ? this.fqansString.length : 0;
        result = result + "fqans";
        result = result + "[";
        for (int i = 0; i < fqansNum; ++i) {
            result = result + this.fqansString[i];
            if (i >= fqansNum - 1) continue;
            result = result + ",";
        }
        result = result + "]";
        return result;
    }

    private String getUserDNTextFormat() {
        String result = "";
        result = result + "dn";
        result = result + this.getUserDN();
        return result;
    }

    public String toString() {
        String result = "";
        result = result + "filename=" + this.fileName + "\t";
        result = result + "userId=" + this.userId + "\t";
        result = result + "vo-name=" + this.voName;
        return result;
    }
}

